/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class LineSepWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LineSepWidget lineSep = new LineSepWidget(view);
        return lineSep;
    }

    private static class LineSepWidget
    implements Widget {
        private final JLabel lineSep = new ToolTipLabel();
        private final View view;

        LineSepWidget(final View view) {
            this.lineSep.setHorizontalAlignment(0);
            this.lineSep.setToolTipText(jEdit.getProperty("view.status.linesep-tooltip"));
            this.view = view;
            this.lineSep.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    view.getBuffer().toggleLineSeparator(view);
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.lineSep;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String lineSep = buffer.getStringProperty("lineSeparator");
            if ("\n".equals(lineSep)) {
                this.lineSep.setText("U");
            } else if ("\r\n".equals(lineSep)) {
                this.lineSep.setText("W");
            } else if ("\r".equals(lineSep)) {
                this.lineSep.setText("M");
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.lineSep.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(Math.max(fm.charWidth('U'), fm.charWidth('W')), fm.charWidth('M')) + 1, fm.getHeight());
            this.lineSep.setPreferredSize(dim);
            this.lineSep.setMaximumSize(dim);
        }
    }
}

