/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;
    protected boolean enterEnabled;

    public EnhancedDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    public EnhancedDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    public boolean getEnterEnabled() {
        return this.enterEnabled;
    }

    public void setEnterEnabled(boolean enterEnabled) {
        this.enterEnabled = enterEnabled;
    }

    public abstract void ok();

    public abstract void cancel();

    private void _init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.enterEnabled = true;
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            EnhancedDialog.this.cancel();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.getKeyCode() == 10 && EnhancedDialog.this.enterEnabled) {
                for (Component comp = EnhancedDialog.this.getFocusOwner(); comp != null; comp = comp.getParent()) {
                    Object selected;
                    if (!(comp instanceof JComboBox)) continue;
                    JComboBox combo = (JComboBox)comp;
                    if (!combo.isEditable() || (selected = combo.getEditor().getItem()) == null) break;
                    combo.setSelectedItem(selected);
                    break;
                }
                EnhancedDialog.this.ok();
                evt.consume();
            } else if (evt.getKeyCode() == 27) {
                EnhancedDialog.this.cancel();
                evt.consume();
            }
        }
    }

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            this.componentAdded(evt.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            this.componentRemoved(evt.getChild());
        }

        private void componentAdded(Component comp) {
            comp.addKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.addContainerListener(this);
                Component[] comps = cont.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    this.componentAdded(comps[i]);
                }
            }
        }

        private void componentRemoved(Component comp) {
            comp.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.removeContainerListener(this);
                Component[] comps = cont.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    this.componentRemoved(comps[i]);
                }
            }
        }
    }
}

