/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.ThreadUtilities;

public class BufferSwitcher
extends JComboBox {
    private final EditPane editPane;
    private boolean updating;

    public BufferSwitcher(final EditPane editPane) {
        this.editPane = editPane;
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addActionListener(new ActionHandler());
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                editPane.getTextArea().requestFocus();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                editPane.getTextArea().requestFocus();
            }
        });
    }

    public void updateBufferList() {
        final BufferSet bufferSet = this.editPane.getBufferSet();
        if (bufferSet.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BufferSwitcher.this.updating = true;
                BufferSwitcher.this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
                BufferSwitcher.this.setModel(new DefaultComboBoxModel<Buffer>(bufferSet.getAllBuffers()));
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.editPane.getBuffer());
                BufferSwitcher.this.setToolTipText(BufferSwitcher.this.editPane.getBuffer().getPath(true));
                BufferSwitcher.this.updating = false;
            }
        };
        ThreadUtilities.runInDispatchThread(runnable);
    }

    static class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Buffer buffer = (Buffer)value;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
                this.setToolTipText(buffer.getPath());
            }
            return this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Buffer buffer;
            if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                BufferSwitcher.this.editPane.setBuffer(buffer);
            }
        }
    }
}

