/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFSFile;

public class ListVFSFileTransferable
implements Transferable {
    public static final DataFlavor jEditFileList = new DataFlavor(List.class, "application/x-java-jEdit-list-vfsfile");
    public static final DataFlavor[] supported = new DataFlavor[]{jEditFileList, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor};
    private final List<VFSFile> files;

    public ListVFSFileTransferable(VFSFile[] files) {
        this.files = Collections.unmodifiableList(Arrays.asList(files));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supported;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return jEditFileList.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (jEditFileList.equals(flavor)) {
            return this.files;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.files.size(); ++i) {
                VFSFile vfsFile = this.files.get(i);
                if (i != 0) {
                    builder.append('\n');
                }
                builder.append(vfsFile);
            }
            return builder.toString();
        }
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            ArrayList<File> files = new ArrayList<File>(this.files.size());
            for (VFSFile file : this.files) {
                if (!(file.getVFS() instanceof FileVFS)) continue;
                files.add(new File(file.getPath()));
            }
            return files;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

