/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.IsabelleSystem$;
import isabelle.Symbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterator;
import scala.Iterator$;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.io.Source$;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsabelleSystem
implements ScalaObject {
    private final Symbol.Interpretation symbols;
    private final Pattern cygdrive_pattern;
    private final boolean is_cygwin;
    private final Map environment = System.getenv();
    private final String charset;

    public IsabelleSystem() {
        this.charset = "UTF-8";
        this.is_cygwin = Pattern.matches(".*-cygwin", this.getenv_strict("ML_PLATFORM"));
        this.cygdrive_pattern = Pattern.compile("/cygdrive/([a-zA-Z])($|/.*)");
        this.symbols = new Symbol.Interpretation((Iterator<String>)((Iterator)this.isabelle$IsabelleSystem$$read_symbols("$ISABELLE_HOME/etc/symbols").$plus$plus((Function0)new $anonfun$1(this))));
    }

    public final void append$1(String path, StringBuilder stringBuilder) {
        new BoxedObjectArray((Object[])this.init$1(path, stringBuilder).split("/")).foreach((Function1)new $anonfun$append$1$1(this, stringBuilder));
    }

    private final String init$1(String path, StringBuilder stringBuilder) {
        String string;
        Matcher cygdrive = this.cygdrive_pattern().matcher(path);
        if (cygdrive.matches()) {
            stringBuilder.length_$eq(0);
            stringBuilder.append(cygdrive.group(1));
            stringBuilder.append(":");
            stringBuilder.append(File.separator);
            string = cygdrive.group(2);
        } else if (path.startsWith("/")) {
            stringBuilder.length_$eq(0);
            stringBuilder.append(this.getenv_strict("ISABELLE_ROOT_JVM"));
            string = path.substring(1);
        } else {
            string = path;
        }
        return string;
    }

    public Symbol.Interpretation symbols() {
        return this.symbols;
    }

    public final Iterator isabelle$IsabelleSystem$$read_symbols(String path) {
        File file = new File(this.platform_path(path));
        return file.canRead() ? Source$.MODULE$.fromFile(file).getLines() : (Iterator)Iterator$.MODULE$.empty();
    }

    public List<String> find_logics() {
        String ml_ident$1 = this.getenv_strict("ML_IDENTIFIER");
        ObjectRef logics$1 = new ObjectRef((Object)Predef$.MODULE$.Set().apply((Seq)new BoxedObjectArray((Object[])new String[0])));
        new BoxedObjectArray((Object[])this.getenv_strict("ISABELLE_PATH").split(":")).foreach((Function1)new $anonfun$find_logics$1(this, ml_ident$1, logics$1));
        return ((Set)logics$1.elem).toList().sort((Function2)new $anonfun$find_logics$2(this));
    }

    public BufferedReader fifo_reader(String fifo) {
        FileInputStream stream = this.is_cygwin() ? this.execute(false, (Seq<String>)new BoxedObjectArray((Object[])new String[]{"cat", fifo})).getInputStream() : new FileInputStream(fifo);
        return new BufferedReader(new InputStreamReader((InputStream)stream, this.charset()));
    }

    public void rm_fifo(String fifo) {
        Tuple2<String, Integer> tuple2 = this.isabelle_tool((Seq<String>)new BoxedObjectArray((Object[])new String[]{"rmfifo", fifo}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String result = (String)tuple22._1();
        int rc = BoxesRunTime.unboxToInt((Object)tuple22._2());
        if (rc != 0) {
            throw Predef$.MODULE$.error(result);
        }
    }

    public String mk_fifo() {
        Tuple2<String, Integer> tuple2 = this.isabelle_tool((Seq<String>)new BoxedObjectArray((Object[])new String[]{"mkfifo"}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String result = (String)tuple22._1();
        int rc = BoxesRunTime.unboxToInt((Object)tuple22._2());
        if (rc == 0) {
            return result.trim();
        }
        throw Predef$.MODULE$.error(result);
    }

    public Tuple2<String, Integer> isabelle_tool(Seq<String> args) {
        Process proc;
        Process exceptionResult1 = null;
        try {
            proc = exceptionResult1 = this.execute(true, (Seq<String>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{this.getenv_strict("ISABELLE_TOOL")})).$plus$plus(args));
        }
        catch (IOException iOException) {
            throw Predef$.MODULE$.error(iOException.getMessage());
        }
        proc.getOutputStream().close();
        String output = Source$.MODULE$.fromInputStream(proc.getInputStream(), this.charset()).mkString();
        int rc = proc.waitFor();
        return new Tuple2((Object)output, (Object)BoxesRunTime.boxToInteger((int)rc));
    }

    public Process execute(boolean redirect, Seq<String> args) {
        LinkedList<String> cmdline$1 = new LinkedList<String>();
        if (this.is_cygwin()) {
            cmdline$1.add(this.platform_path("/bin/env"));
        }
        args.foreach((Function1)new $anonfun$execute$1(this, cmdline$1));
        ProcessBuilder proc = new ProcessBuilder(cmdline$1);
        proc.environment().clear();
        proc.environment().putAll(this.environment());
        proc.redirectErrorStream(redirect);
        return proc.start();
    }

    public File platform_file(String path) {
        return new File(this.platform_path(path));
    }

    public String platform_path(String source_path) {
        StringBuilder result_path$1 = new StringBuilder();
        new BoxedObjectArray((Object[])this.init$1(source_path, result_path$1).split("/")).foreach((Function1)new $anonfun$platform_path$1(this, result_path$1));
        return result_path$1.toString();
    }

    private Pattern cygdrive_pattern() {
        return this.cygdrive_pattern;
    }

    public boolean is_cygwin() {
        return this.is_cygwin;
    }

    public String getenv_strict(String name) {
        String value;
        String string = value = (String)this.environment().get(name);
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Undefined environment variable: ").append((Object)name).toString());
        }
        return value;
    }

    public String getenv(String name) {
        String value;
        String string = name;
        String string2 = "HOME";
        String string3 = value = (String)this.environment().get(!(string != null ? !string.equals(string2) : string2 != null) ? "HOME_JVM" : name);
        return string3 == null || string3.equals(null) ? "" : value;
    }

    private Map environment() {
        return this.environment;
    }

    public String charset() {
        return this.charset;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

