/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.GraphBrowser;
import awtUtilities.MessageDialog;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GraphBrowserFrame
extends Frame
implements ActionListener {
    GraphBrowser gb;
    MenuItem i1;
    MenuItem i2;
    String graphDir;
    String psDir;

    public void checkMenuItems() {
        if (this.gb.isEmpty()) {
            this.i1.setEnabled(false);
            this.i2.setEnabled(false);
        } else {
            this.i1.setEnabled(true);
            this.i2.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Quit")) {
            System.exit(0);
        } else {
            if (string.equals("Export to PostScript")) {
                this.PS(true, string);
                return;
            }
            if (string.equals("Export to EPS")) {
                this.PS(false, string);
                return;
            }
            if (string.equals("Open ...")) {
                FileDialog fileDialog = new FileDialog((Frame)this, "Open graph file", 0);
                if (this.graphDir != null) {
                    fileDialog.setDirectory(this.graphDir);
                }
                ((Component)fileDialog).setVisible(true);
                if (fileDialog.getFile() == null) {
                    return;
                }
                this.graphDir = fileDialog.getDirectory();
                String string2 = this.graphDir + fileDialog.getFile();
                GraphBrowser graphBrowser = new GraphBrowser(string2);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    graphBrowser.initBrowser(fileInputStream, false);
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    String[] stringArray = new String[]{"OK"};
                    MessageDialog messageDialog = new MessageDialog((Frame)this, "Error", "Can't open file " + string2 + ".", stringArray);
                    ((Component)messageDialog).setSize(350, 200);
                    ((Component)messageDialog).setVisible(true);
                    return;
                }
                this.remove(this.gb);
                this.add("Center", graphBrowser);
                this.gb = graphBrowser;
                this.checkMenuItems();
                this.validate();
            }
        }
    }

    public void PS(boolean bl, String string) {
        Object object;
        FileDialog fileDialog = new FileDialog((Frame)this, string, 1);
        if (this.psDir != null) {
            fileDialog.setDirectory(this.psDir);
        }
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.psDir = fileDialog.getDirectory();
        String string2 = this.psDir + fileDialog.getFile();
        if (new File(string2).exists()) {
            String[] stringArray = new String[]{"Overwrite", "Cancel"};
            object = new MessageDialog((Frame)this, "Warning", "Warning: File " + string2 + " already exists. Overwrite?", stringArray);
            ((Component)object).setSize(350, 200);
            ((Component)object).setVisible(true);
            if (((MessageDialog)object).getText().equals("Cancel")) {
                return;
            }
        }
        try {
            this.gb.PS(string2, bl);
        }
        catch (IOException iOException) {
            object = new String[]{"OK"};
            MessageDialog messageDialog = new MessageDialog((Frame)this, "Error", "Unable to write file " + string2 + ".", (String[])object);
            ((Component)messageDialog).setSize(350, 200);
            ((Component)messageDialog).setVisible(true);
        }
    }

    public GraphBrowserFrame(GraphBrowser graphBrowser) {
        super("GraphBrowser");
        this.gb = graphBrowser;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Open ...");
        menu.add(menuItem);
        this.i1 = new MenuItem("Export to PostScript");
        menu.add(this.i1);
        this.i2 = new MenuItem("Export to EPS");
        menu.add(this.i2);
        MenuItem menuItem2 = new MenuItem("Quit");
        menu.add(menuItem2);
        this.i1.addActionListener(this);
        this.i2.addActionListener(this);
        menuItem.addActionListener(this);
        menuItem2.addActionListener(this);
        this.checkMenuItems();
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.add("Center", graphBrowser);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }
}

