(* ========================================================================= *)
(* Results intended for Flyspeck.                                            *)
(* ========================================================================= *)

needs "Multivariate/cross.ml";;
needs "Multivariate/geom.ml";;
needs "Multivariate/measure.ml";;

prioritize_vector();;

(* ------------------------------------------------------------------------- *)
(* Not really Flyspeck-specific but needs both angles and cross products.    *)
(* ------------------------------------------------------------------------- *)

let NORM_CROSS = prove
 (`!x y. norm(x cross y) = norm(x) * norm(y) * sin(vector_angle x y)`,
  REPEAT GEN_TAC THEN
  MATCH_MP_TAC REAL_POW_EQ THEN EXISTS_TAC `2` THEN
  SIMP_TAC[NORM_POS_LE; SIN_VECTOR_ANGLE_POS; REAL_LE_MUL; ARITH_EQ] THEN
  MP_TAC(SPECL [`x:real^3`; `y:real^3`] NORM_CROSS_DOT) THEN
  REWRITE_TAC[VECTOR_ANGLE] THEN
  MP_TAC(SPEC `vector_angle (x:real^3) y` SIN_CIRCLE) THEN
  CONV_TAC REAL_RING);;

(* ------------------------------------------------------------------------- *)
(* Negligibility of a circular cone.                                         *)
(* ------------------------------------------------------------------------- *)

let NEGLIGIBLE_CIRCULAR_CONE_0_NONPARALLEL = prove
 (`!c:real^N k. ~(c = vec 0) /\ ~(k = &0) /\ ~(k = pi)
                ==> negligible {x | vector_angle c x = k}`,
  REPEAT STRIP_TAC THEN MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN
  EXISTS_TAC `(vec 0:real^N) INSERT
              UNIONS { {x | x IN ((:real^N) DIFF ball(vec 0,inv(&n + &1))) /\
                            Cx(vector_angle c x) = Cx k} |
                       n IN (:num)  }` THEN
  CONJ_TAC THENL
   [ALL_TAC;
    REWRITE_TAC[SUBSET; IN_INSERT; IN_UNIONS; IN_ELIM_THM; CX_INJ] THEN
    X_GEN_TAC `x:real^N` THEN DISCH_TAC THEN REWRITE_TAC[IN_UNIV] THEN
    ASM_CASES_TAC `x:real^N = vec 0` THEN ASM_REWRITE_TAC[] THEN
    REWRITE_TAC[LEFT_AND_EXISTS_THM; IN_DIFF; IN_UNIV] THEN
    ONCE_REWRITE_TAC[SWAP_EXISTS_THM] THEN REWRITE_TAC[UNWIND_THM2] THEN
    ASM_REWRITE_TAC[IN_ELIM_THM] THEN
    MP_TAC(SPEC `norm(x:real^N)` REAL_ARCH_INV) THEN
    ASM_REWRITE_TAC[NORM_POS_LT; IN_BALL_0; REAL_NOT_LT; REAL_LT_INV_EQ] THEN
    MATCH_MP_TAC MONO_EXISTS THEN REPEAT STRIP_TAC THEN
    MATCH_MP_TAC REAL_LE_TRANS THEN EXISTS_TAC `inv(&n)` THEN
    ASM_SIMP_TAC[REAL_LT_IMP_LE] THEN MATCH_MP_TAC REAL_LE_INV2 THEN
    ASM_REAL_ARITH_TAC] THEN
  REWRITE_TAC[NEGLIGIBLE_INSERT] THEN
  MATCH_MP_TAC NEGLIGIBLE_COUNTABLE_UNIONS THEN X_GEN_TAC `n:num` THEN
  MATCH_MP_TAC STARLIKE_NEGLIGIBLE_STRONG THEN EXISTS_TAC `c:real^N` THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC CONTINUOUS_CLOSED_PREIMAGE_CONSTANT THEN
    SIMP_TAC[CLOSED_DIFF; CLOSED_UNIV; OPEN_BALL] THEN
    MATCH_MP_TAC(REWRITE_RULE[o_DEF] CONTINUOUS_ON_CX_VECTOR_ANGLE) THEN
    REWRITE_TAC[IN_DIFF; IN_BALL_0; NORM_0; IN_UNIV] THEN
    REWRITE_TAC[REAL_LT_INV_EQ] THEN REAL_ARITH_TAC;
    ALL_TAC] THEN
  MAP_EVERY X_GEN_TAC [`a:real`; `x:real^N`] THEN
  SIMP_TAC[IN_ELIM_THM; IN_UNIV; IN_DIFF; IN_BALL_0; REAL_NOT_LT; CX_INJ] THEN
  REWRITE_TAC[DE_MORGAN_THM] THEN ASM_CASES_TAC `(c + x:real^N) = vec 0` THENL
   [ASM_REWRITE_TAC[GSYM REAL_NOT_LT; REAL_LT_INV_EQ; NORM_0] THEN
    REAL_ARITH_TAC;
    ALL_TAC] THEN
  ASM_CASES_TAC `c + a % x:real^N = vec 0` THENL
   [ASM_REWRITE_TAC[GSYM REAL_NOT_LT; REAL_LT_INV_EQ; NORM_0] THEN
    REAL_ARITH_TAC;
    ALL_TAC] THEN
  ASM_CASES_TAC `x:real^N = vec 0` THENL
   [ASM_REWRITE_TAC[VECTOR_ADD_RID; VECTOR_ANGLE_REFL];
    ALL_TAC] THEN
  ASM_CASES_TAC `a = &0` THENL
   [ASM_REWRITE_TAC[VECTOR_MUL_LZERO; VECTOR_ADD_RID; VECTOR_ANGLE_REFL];
    ALL_TAC] THEN
  REWRITE_TAC[TAUT `~a \/ ~b <=> a ==> ~b`] THEN REPEAT STRIP_TAC THEN
  MP_TAC(ISPECL [`vec 0:real^N`; `c:real^N`; `c + a % x:real^N`;
                 `vec 0:real^N`; `c:real^N`; `c + x:real^N`]
                CONGRUENT_TRIANGLES_ASA_FULL) THEN
  REWRITE_TAC[angle; VECTOR_ADD_SUB] THEN ASM_SIMP_TAC[VECTOR_SUB_RZERO] THEN
  REWRITE_TAC[NORM_ARITH `dist(x,x + a) = norm(a)`; NORM_MUL] THEN
  REWRITE_TAC[REAL_FIELD `a * x = x <=> a = &1 \/ x = &0`] THEN
  ASM_SIMP_TAC[REAL_ARITH `&0 <= a /\ a < &1 ==> ~(abs a = &1)`] THEN
  ASM_REWRITE_TAC[NORM_EQ_0; VECTOR_ANGLE_RMUL; COLLINEAR_LEMMA] THEN
  DISCH_THEN(X_CHOOSE_THEN `u:real` MP_TAC) THEN
  DISCH_THEN(MP_TAC o AP_TERM `\x:real^N. inv(a) % x`) THEN
  ASM_SIMP_TAC[VECTOR_MUL_ASSOC; VECTOR_ADD_LDISTRIB;
               VECTOR_MUL_LID; REAL_MUL_LINV] THEN
  REWRITE_TAC[VECTOR_ARITH `a % c + x = b % c <=> x = (b - a) % c`] THEN
  DISCH_THEN SUBST_ALL_TAC THEN
  RULE_ASSUM_TAC(REWRITE_RULE[VECTOR_ARITH `c + a % c = (a + &1) % c`]) THEN
  UNDISCH_TAC `vector_angle c ((inv a * u - inv a + &1) % c:real^N) = k` THEN
  RULE_ASSUM_TAC(REWRITE_RULE
   [VECTOR_ANGLE_RMUL; VECTOR_MUL_EQ_0; DE_MORGAN_THM]) THEN
  ASM_REWRITE_TAC[VECTOR_ANGLE_RMUL; VECTOR_ANGLE_REFL] THEN
  ASM_REAL_ARITH_TAC);;

let NEGLIGIBLE_CIRCULAR_CONE_0 = prove
 (`!c:real^N k. 2 <= dimindex(:N) /\ ~(c = vec 0)
                ==> negligible {x | vector_angle c x = k}`,
  REPEAT STRIP_TAC THEN
  SUBGOAL_THEN `orthogonal (basis 1:real^N) (basis 2)` ASSUME_TAC THENL
   [ASM_SIMP_TAC[ORTHOGONAL_BASIS_BASIS; ARITH;
                 ARITH_RULE `2 <= d ==> 1 <= d`];
    ALL_TAC] THEN
  ASM_CASES_TAC `k = &0 \/ k = pi` THENL
   [ALL_TAC; ASM_MESON_TAC[NEGLIGIBLE_CIRCULAR_CONE_0_NONPARALLEL]] THEN
  SUBGOAL_THEN
   `?b:real^N. ~(b = vec 0) /\
               ~(vector_angle c b = &0) /\
               ~(vector_angle c b = pi)`
  STRIP_ASSUME_TAC THENL
   [MATCH_MP_TAC(MESON[] `!a b. P a \/ P b ==> ?x. P x`) THEN
    MAP_EVERY EXISTS_TAC [`basis 1:real^N`; `basis 2:real^N`] THEN
    REWRITE_TAC[BASIS_EQ_0] THEN
    ASM_SIMP_TAC[ARITH_RULE `2 <= d ==> 1 <= d`; IN_NUMSEG; ARITH] THEN
    REWRITE_TAC[GSYM DE_MORGAN_THM] THEN STRIP_TAC THEN
    REPEAT(FIRST_X_ASSUM(MP_TAC o SPEC `basis 1:real^N` o
      MATCH_MP VECTOR_ANGLE_EQ_0_LEFT)) THEN
    REPEAT(FIRST_X_ASSUM(MP_TAC o SPEC `basis 1:real^N` o
      MATCH_MP VECTOR_ANGLE_EQ_PI_LEFT)) THEN
    DISCH_THEN SUBST1_TAC THEN REWRITE_TAC[VECTOR_ANGLE_REFL; BASIS_EQ_0] THEN
    ASM_SIMP_TAC[ARITH_RULE `2 <= d ==> 1 <= d`; IN_NUMSEG; ARITH] THEN
    FIRST_X_ASSUM(MP_TAC o GEN_REWRITE_RULE I [ORTHOGONAL_VECTOR_ANGLE]) THEN
    REWRITE_TAC[VECTOR_ANGLE_SYM] THEN MP_TAC PI_POS THEN REAL_ARITH_TAC;
    ALL_TAC] THEN
  ASM_CASES_TAC `k = &0 \/ k = pi` THENL
   [ALL_TAC; ASM_MESON_TAC[NEGLIGIBLE_CIRCULAR_CONE_0_NONPARALLEL]] THEN
  MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN
  FIRST_X_ASSUM(DISJ_CASES_THEN SUBST_ALL_TAC) THENL
   [EXISTS_TAC `{x:real^N | vector_angle b x = vector_angle c b}` THEN
    ASM_SIMP_TAC[NEGLIGIBLE_CIRCULAR_CONE_0_NONPARALLEL] THEN
    REWRITE_TAC[SUBSET; IN_ELIM_THM] THEN
    MESON_TAC[VECTOR_ANGLE_EQ_0_RIGHT; VECTOR_ANGLE_SYM];
    EXISTS_TAC `{x:real^N | vector_angle b x = pi - vector_angle c b}` THEN
    ASM_SIMP_TAC[NEGLIGIBLE_CIRCULAR_CONE_0_NONPARALLEL;
                 REAL_SUB_0; REAL_ARITH `p - x = p <=> x = &0`] THEN
    REWRITE_TAC[SUBSET; IN_ELIM_THM] THEN
    MESON_TAC[VECTOR_ANGLE_EQ_PI_RIGHT; VECTOR_ANGLE_SYM]]);;

let NEGLIGIBLE_CIRCULAR_CONE = prove
 (`!a:real^N c k.
      2 <= dimindex(:N) /\ ~(c = vec 0)
      ==> negligible(a INSERT {x | vector_angle c (x - a) = k})`,
  REPEAT STRIP_TAC THEN REWRITE_TAC[NEGLIGIBLE_INSERT] THEN
  MATCH_MP_TAC NEGLIGIBLE_TRANSLATION_REV THEN EXISTS_TAC `--a:real^N` THEN
  MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN
  EXISTS_TAC `{x:real^N | vector_angle c x = k}` THEN
  ASM_SIMP_TAC[NEGLIGIBLE_CIRCULAR_CONE_0] THEN
  REWRITE_TAC[SUBSET; FORALL_IN_IMAGE; IN_ELIM_THM] THEN
  REWRITE_TAC[VECTOR_ARITH `--a + x:real^N = x - a`]);;

(* ------------------------------------------------------------------------- *)
(* Volume of a tetrahedron.                                                  *)
(* ------------------------------------------------------------------------- *)

let delta_x = new_definition
 `delta_x x1 x2 x3 x4 x5 x6 =
        x1*x4*(--x1 + x2 + x3 -x4 + x5 + x6) +
        x2*x5*(x1 - x2 + x3 + x4 -x5 + x6) +
        x3*x6*(x1 + x2 - x3 + x4 + x5 - x6)
        -x2*x3*x4 - x1*x3*x5 - x1*x2*x6 -x4*x5*x6:real`;;

let VOLUME_OF_TETRAHEDRON = prove
 (`!x1 x2 x3 x4:real^3.
     measure(convex hull {x1,x2,x3,x4}) =
     sqrt(delta_x (dist(x1,x2) pow 2) (dist(x1,x3) pow 2) (dist(x1,x4) pow 2)
                  (dist(x3,x4) pow 2) (dist(x2,x4) pow 2) (dist(x2,x3) pow 2))
      / &12`,
  REPEAT GEN_TAC THEN REWRITE_TAC[LET_DEF; LET_END_DEF] THEN
  REWRITE_TAC[MEASURE_TETRAHEDRON] THEN
  REWRITE_TAC[REAL_ARITH `x / &6 = y / &12 <=> y = &2 * x`] THEN
  MATCH_MP_TAC SQRT_UNIQUE THEN
  SIMP_TAC[REAL_LE_MUL; REAL_ABS_POS; REAL_POS] THEN
  REWRITE_TAC[REAL_POW_MUL; REAL_POW2_ABS; delta_x] THEN
  REWRITE_TAC[dist; NORM_POW_2] THEN
  SIMP_TAC[DOT_3; VECTOR_SUB_COMPONENT; DIMINDEX_3; ARITH] THEN
  CONV_TAC REAL_RING);;
