(* ========================================================================= *)
(* Area of a circle.                                                         *)
(* ========================================================================= *)

needs "Multivariate/measure.ml";;
needs "Multivariate/real.ml";;

(* ------------------------------------------------------------------------- *)
(* The antiderivative we use.                                                *)
(* ------------------------------------------------------------------------- *)

let ANTIDERIVATIVE_SQRT_1X2 = prove
 (`!x. abs(x) < &1
       ==> ((\x. (asn(x) + x * sqrt(&1 - x pow 2))) has_real_derivative
            &2 * sqrt(&1 - x pow 2)) (atreal x)`,
  REPEAT STRIP_TAC THEN REAL_DIFF_TAC THEN
  CONV_TAC NUM_REDUCE_CONV THEN
  REWRITE_TAC[REAL_MUL_LID; REAL_POW_1; REAL_MUL_RID] THEN
  REWRITE_TAC[REAL_SUB_LZERO; REAL_MUL_RNEG; REAL_INV_MUL] THEN
  ASM_REWRITE_TAC[REAL_SUB_LT; ABS_SQUARE_LT_1] THEN
  MATCH_MP_TAC(REAL_FIELD
   `s pow 2 = &1 - x pow 2 /\ x pow 2 < &1
    ==> (inv s + x * --(&2 * x) * inv (&2) * inv s + s) = &2 * s`) THEN
  ASM_SIMP_TAC[ABS_SQUARE_LT_1; SQRT_POW_2; REAL_SUB_LE; REAL_LT_IMP_LE]);;

(* ------------------------------------------------------------------------- *)
(* Hence the proof by "integration".                                         *)
(* ------------------------------------------------------------------------- *)

let MEASURABLE_CIRCLE_CHUNK = prove
 (`!a b. measurable {z:real^2 | a <= z$1 /\ z$1 <= b /\ norm(z) <= &1}`,
  REPEAT STRIP_TAC THEN MATCH_MP_TAC MEASURABLE_COMPACT THEN
  REWRITE_TAC[COMPACT_EQ_BOUNDED_CLOSED] THEN CONJ_TAC THENL
   [MATCH_MP_TAC BOUNDED_SUBSET THEN EXISTS_TAC `cball(vec 0:real^2,&1)` THEN
    SIMP_TAC[BOUNDED_CBALL; SUBSET; IN_ELIM_THM; IN_CBALL;
             NORM_ARITH `dist(vec 0,x) = norm x`];
    REWRITE_TAC[SET_RULE `{x | P x /\ Q x} = {x | P x} INTER {x | Q x}`] THEN
    REWRITE_TAC[NORM_ARITH `norm x = dist(vec 0,x)`; GSYM cball] THEN
    REWRITE_TAC[REAL_ARITH `a <= z$1 <=> z$1 >= a`] THEN
    SIMP_TAC[CLOSED_INTER; CLOSED_HALFSPACE_COMPONENT_LE;
             CLOSED_HALFSPACE_COMPONENT_GE; CLOSED_CBALL;
             DIMINDEX_2; ARITH]]);;

let MEASURE_CIRCLE_CHUNK = prove
 (`!x. &0 <= x /\ x < &1
       ==> measure {z:real^2 | &0 <= z$1 /\ z$1 <= x /\ norm(z) <= &1} =
             asn(x) + x * sqrt(&1 - x pow 2)`,
  SUBGOAL_THEN
   `!a. &0 <= a /\ a < &1
        ==> !x. x IN {x | &0 <= x /\ x <= a}
                ==> measure{z:real^2 | &0 <= z$1 /\ z$1 <= x /\ norm(z) <= &1} -
                    (asn(x) + x * sqrt(&1 - x pow 2)) = &0`
  MP_TAC THENL
   [ALL_TAC;
    REWRITE_TAC[IN_ELIM_THM; REAL_SUB_0] THEN
    ASM_MESON_TAC[REAL_LE_REFL; REAL_LET_TRANS]] THEN
  GEN_TAC THEN STRIP_TAC THEN MATCH_MP_TAC HAS_REAL_DERIVATIVE_ZERO_UNIQUE THEN
  EXISTS_TAC `&0` THEN
  ASM_REWRITE_TAC[is_realinterval; IN_ELIM_THM; REAL_POS] THEN
  CONJ_TAC THENL [REAL_ARITH_TAC; CONV_TAC REAL_RAT_REDUCE_CONV] THEN
  REWRITE_TAC[REAL_MUL_LZERO; ASN_0; REAL_ADD_LID] THEN
  CONV_TAC REAL_RAT_REDUCE_CONV THEN REWRITE_TAC[REAL_SUB_RZERO] THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC MEASURE_UNIQUE THEN REWRITE_TAC[HAS_MEASURE_0] THEN
    MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN EXISTS_TAC `{z:real^2 | z$1 = &0}` THEN
    SIMP_TAC[NEGLIGIBLE_STANDARD_HYPERPLANE; DIMINDEX_2; ARITH] THEN
    REWRITE_TAC[SUBSET; IN_ELIM_THM] THEN REAL_ARITH_TAC;
    ALL_TAC] THEN
  X_GEN_TAC `x:real` THEN STRIP_TAC THEN
  SUBGOAL_THEN `x < &1` ASSUME_TAC THENL [ASM_ARITH_TAC; ALL_TAC] THEN
  SUBST1_TAC(REAL_ARITH
   `&0 = &2 * sqrt(&1 - x pow 2) - &2 * sqrt(&1 - x pow 2)`) THEN
  MATCH_MP_TAC HAS_REAL_DERIVATIVE_SUB THEN REWRITE_TAC[REAL_SUB_REFL] THEN
  CONJ_TAC THENL
   [ALL_TAC;
    MATCH_MP_TAC HAS_REAL_DERIVATIVE_ATREAL_WITHIN THEN
    MATCH_MP_TAC ANTIDERIVATIVE_SQRT_1X2 THEN ASM_REAL_ARITH_TAC] THEN
  REWRITE_TAC[HAS_REAL_DERIVATIVE_WITHINREAL; REALLIM_WITHINREAL] THEN
  X_GEN_TAC `e:real` THEN DISCH_TAC THEN
  SUBGOAL_THEN `(\t. &2 * sqrt(&1 - t pow 2)) real_continuous (atreal x)`
  MP_TAC THENL
   [MATCH_MP_TAC REAL_DIFFERENTIABLE_IMP_CONTINUOUS_ATREAL THEN
    REAL_DIFFERENTIABLE_TAC THEN
    ASM_SIMP_TAC[REAL_SUB_LT; ABS_SQUARE_LT_1] THEN ASM_ARITH_TAC;
    ALL_TAC] THEN
  REWRITE_TAC[real_continuous_atreal; IN_ELIM_THM] THEN
  DISCH_THEN(MP_TAC o SPEC `e / &2`) THEN ASM_REWRITE_TAC[REAL_HALF] THEN
  MATCH_MP_TAC MONO_EXISTS THEN X_GEN_TAC `d:real` THEN
  STRIP_TAC THEN ASM_REWRITE_TAC[] THEN X_GEN_TAC `y:real` THEN
  REWRITE_TAC[GSYM REAL_ABS_NZ; REAL_SUB_0] THEN STRIP_TAC THEN
  SUBGOAL_THEN
   `(measure {z:real^2 | &0 <= z$1 /\ z$1 <= y /\ norm z <= &1} -
     measure {z:real^2 | &0 <= z$1 /\ z$1 <= x /\ norm z <= &1}) / (y - x) =
    measure { z:real^2 | min x y <= z$1 /\ z$1 <= max x y /\
                         norm z <= &1 } / abs(y - x)`
  SUBST1_TAC THENL
   [REWRITE_TAC[real_abs; REAL_SUB_LE] THEN COND_CASES_TAC THENL
     [ASM_SIMP_TAC[REAL_ARITH `x <= y ==> min x y = x /\ max x y = y`];
      ASM_SIMP_TAC[REAL_ARITH `~(x <= y) ==> min x y = y /\ max x y = x`] THEN
      REWRITE_TAC[real_div; REAL_INV_NEG; REAL_MUL_RNEG] THEN
      SIMP_TAC[REAL_ARITH `(a - b) * c:real = --d <=> (b - a) * c = d`]] THEN
    AP_THM_TAC THEN AP_TERM_TAC THEN
    W(MP_TAC o PART_MATCH (rand o rand) MEASURE_DIFF_SUBSET o lhs o snd) THEN
    REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; SUBSET; IN_ELIM_THM] THEN
    (ANTS_TAC THENL [ASM_REAL_ARITH_TAC; DISCH_THEN(SUBST1_TAC o SYM)]) THEN
    MATCH_MP_TAC MEASURE_NEGLIGIBLE_SYMDIFF THEN
    SIMP_TAC[MEASURABLE_DIFF; MEASURABLE_CIRCLE_CHUNK] THEN
    MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN
    EXISTS_TAC `{z:real^2 | z$1 = x} UNION {z:real^2 | z$1 = y}` THEN
    SIMP_TAC[NEGLIGIBLE_UNION; NEGLIGIBLE_STANDARD_HYPERPLANE;
             DIMINDEX_2; ARITH] THEN
    REWRITE_TAC[IN_UNION; IN_DIFF; SUBSET; IN_ELIM_THM] THEN
    ASM_REAL_ARITH_TAC;
    ALL_TAC] THEN
  REWRITE_TAC[REAL_ABS_DIV] THEN
  MATCH_MP_TAC(REAL_ARITH
   `!a b. a <= x /\ x <= b /\ abs(a - z) < e /\ abs(b - z) < e
          ==> abs(x - z) < e`) THEN
  MAP_EVERY EXISTS_TAC
   [`&2 * sqrt(&1 - x pow 2) - e / &2`; `&2 * sqrt(&1 - x pow 2) + e / &2`] THEN
  ASM_SIMP_TAC[REAL_LE_RDIV_EQ; REAL_LE_LDIV_EQ;
               GSYM REAL_ABS_NZ; REAL_SUB_0] THEN
  REWRITE_TAC[REAL_ARITH `abs(y - x) = max x y - min x y`] THEN
  REWRITE_TAC[CONJ_ASSOC] THEN
  REPLICATE_TAC 2 (CONJ_TAC THENL [ALL_TAC; ASM_REAL_ARITH_TAC]) THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC REAL_LE_TRANS THEN EXISTS_TAC
     `measure(interval[vector[min x y;--(sqrt(&1 - x pow 2) - e / &4)]:real^2,
                       vector[max x y;sqrt(&1 - x pow 2) - e / &4]])` THEN
    CONJ_TAC THENL
     [REWRITE_TAC[MEASURE_INTERVAL; CONTENT_CLOSED_INTERVAL_CASES] THEN
      REWRITE_TAC[PRODUCT_2; VECTOR_2; FORALL_2; DIMINDEX_2] THEN
      REWRITE_TAC[REAL_ARITH
       `min x y <= max x y /\ --(s - e / &4) <= s - e / &4 <=>
        &0 <= &2 * s - e / &2`] THEN
      COND_CASES_TAC THENL [REAL_ARITH_TAC; ALL_TAC] THEN
      MATCH_MP_TAC(REAL_ARITH `&0 <= (x - y) * a ==> (y - x) * a <= &0`) THEN
      MATCH_MP_TAC REAL_LE_MUL THEN ASM_REAL_ARITH_TAC;
      MATCH_MP_TAC MEASURE_SUBSET THEN
      REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; MEASURABLE_INTERVAL;
                  GSYM CONJ_ASSOC] THEN
      REWRITE_TAC[SUBSET; IN_INTERVAL; DIMINDEX_2; FORALL_2; VECTOR_2;
                  IN_ELIM_THM] THEN
      REWRITE_TAC[REAL_BOUNDS_LE] THEN
      X_GEN_TAC `z:real^2` THEN STRIP_TAC THEN ASM_REWRITE_TAC[] THEN
      REWRITE_TAC[NORM_LE_SQUARE; REAL_POS; DOT_2; REAL_POW_ONE] THEN
      MATCH_MP_TAC(REAL_ARITH
       `!a. z pow 2 <= a /\ a <= &1 - w pow 2 ==> w * w + z * z <= &1`) THEN
      EXISTS_TAC `(sqrt(&1 - x pow 2) - e / &4) pow 2` THEN
      FIRST_ASSUM(STRIP_ASSUME_TAC o MATCH_MP (REAL_ARITH
       `abs(x) <= a ==> &0 <= a /\ x <= a`)) THEN
      GEN_REWRITE_TAC (LAND_CONV o LAND_CONV) [GSYM REAL_POW2_ABS] THEN
      ASM_SIMP_TAC[REAL_POW_LE2; REAL_ABS_POS] THEN
      MATCH_MP_TAC REAL_RSQRT_LE THEN ASM_REWRITE_TAC[] THEN
      ASM_SIMP_TAC[REAL_SUB_LE; ABS_SQUARE_LE_1] THEN
      CONJ_TAC THENL [ASM_REAL_ARITH_TAC; ALL_TAC] THEN
      MATCH_MP_TAC(REAL_ARITH
       `abs(&2 * x - &2 * y) < e / &2 ==> y - e / &4 <= x`) THEN
      FIRST_X_ASSUM MATCH_MP_TAC THEN ASM_REAL_ARITH_TAC];
    MATCH_MP_TAC REAL_LE_TRANS THEN EXISTS_TAC
     `measure(interval[vector[min x y;--(sqrt(&1 - x pow 2) + e / &4)]:real^2,
                       vector[max x y;sqrt(&1 - x pow 2) + e / &4]])` THEN
    CONJ_TAC THENL
     [MATCH_MP_TAC MEASURE_SUBSET THEN
      REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; MEASURABLE_INTERVAL;
                  GSYM CONJ_ASSOC] THEN
      REWRITE_TAC[SUBSET; IN_INTERVAL; DIMINDEX_2; FORALL_2; VECTOR_2;
                  IN_ELIM_THM] THEN
      REWRITE_TAC[REAL_BOUNDS_LE] THEN
      REWRITE_TAC[NORM_LE_SQUARE; REAL_POS; DOT_2; REAL_POW_ONE] THEN
      X_GEN_TAC `z:real^2` THEN STRIP_TAC THEN ASM_REWRITE_TAC[] THEN
      MATCH_MP_TAC REAL_LE_TRANS THEN
      EXISTS_TAC `sqrt(&1 - (z:real^2)$1 pow 2)` THEN
      REWRITE_TAC[GSYM POW_2_SQRT_ABS] THEN CONJ_TAC THENL
       [MATCH_MP_TAC SQRT_MONO_LE THEN
        REWRITE_TAC[REAL_POW_2; REAL_LE_SQUARE] THEN ASM_REAL_ARITH_TAC;
        MATCH_MP_TAC(REAL_ARITH
         `abs(&2 * x - &2 * y) < e / &2 ==> x <= y + e / &4`) THEN
        FIRST_X_ASSUM MATCH_MP_TAC THEN ASM_REAL_ARITH_TAC];
      REWRITE_TAC[MEASURE_INTERVAL; CONTENT_CLOSED_INTERVAL_CASES] THEN
      REWRITE_TAC[PRODUCT_2; VECTOR_2; FORALL_2; DIMINDEX_2] THEN
      REWRITE_TAC[REAL_ARITH
       `min x y <= max x y /\ --(s + e / &4) <= s + e / &4 <=>
        &0 <= &2 * s + e / &2`] THEN
      COND_CASES_TAC THENL [REAL_ARITH_TAC; ALL_TAC] THEN
      FIRST_X_ASSUM(MP_TAC o GEN_REWRITE_RULE I [REAL_NOT_LE]) THEN
      MATCH_MP_TAC(REAL_ARITH
       `&0 < x /\ &0 <= y ==> &2 * y + x / &2 < &0 ==> &0 <= v`) THEN
      ASM_REWRITE_TAC[] THEN MATCH_MP_TAC SQRT_POS_LE THEN
      ASM_SIMP_TAC[REAL_SUB_LE; ABS_SQUARE_LE_1] THEN ASM_REAL_ARITH_TAC]]);;

(* ------------------------------------------------------------------------- *)
(* Now a continuity argument to fill in the RHS.                             *)
(* We could have used a strong uniqueness for derivative, but then the       *)
(* bidirectional continuity argument is basically the same, maybe worse.     *)
(* ------------------------------------------------------------------------- *)

let MEASURE_UNIT_SEMICIRCLE_DELTA = prove
 (`!x. x < &1
       ==> abs(measure {z:real^2 | &0 <= z$1 /\ z$1 <= &1 /\ norm z <= &1} -
               measure {z:real^2 | &0 <= z$1 /\ z$1 <= x /\ norm z <= &1})
             <= &2 * (&1 - x)`,
  REPEAT STRIP_TAC THEN
  MATCH_MP_TAC(REAL_ARITH `x <= y /\ y - x <= e ==> abs(y - x) <= e`) THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC MEASURE_SUBSET THEN
    REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; SUBSET; IN_ELIM_THM] THEN
    ASM_REAL_ARITH_TAC;
    ALL_TAC] THEN
  MATCH_MP_TAC REAL_LE_TRANS THEN
  EXISTS_TAC `measure {z:real^2 | x <= z$1 /\ z$1 <= &1 /\ norm z <= &1}` THEN
  CONJ_TAC THENL
   [W(MP_TAC o PART_MATCH (rand o rand) MEASURE_DIFF_SUBSET o lhand o snd) THEN
    REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; SUBSET; IN_ELIM_THM] THEN
    (ANTS_TAC THENL [ASM_REAL_ARITH_TAC; DISCH_THEN(SUBST1_TAC o SYM)]) THEN
    MATCH_MP_TAC MEASURE_SUBSET THEN
    SIMP_TAC[MEASURABLE_DIFF; MEASURABLE_CIRCLE_CHUNK] THEN
    REWRITE_TAC[SUBSET; IN_DIFF; IN_ELIM_THM] THEN REAL_ARITH_TAC;
    ALL_TAC] THEN
  MATCH_MP_TAC REAL_LE_TRANS THEN
  EXISTS_TAC `measure(interval[vector[x;-- &1]:real^2,vector[&1; &1]])` THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC MEASURE_SUBSET THEN
    REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK; MEASURABLE_INTERVAL] THEN
    REWRITE_TAC[SUBSET; IN_INTERVAL; VECTOR_2; DIMINDEX_2; FORALL_2;
                IN_ELIM_THM; REAL_BOUNDS_LE] THEN
    X_GEN_TAC `z:real^2` THEN STRIP_TAC THEN ASM_REWRITE_TAC[] THEN
    MATCH_MP_TAC REAL_LE_TRANS THEN EXISTS_TAC `norm(z:real^2)` THEN
    ASM_SIMP_TAC[COMPONENT_LE_NORM; DIMINDEX_2; ARITH];
    REWRITE_TAC[MEASURE_INTERVAL; CONTENT_CLOSED_INTERVAL_CASES] THEN
    ASM_SIMP_TAC[PRODUCT_2; VECTOR_2; FORALL_2; DIMINDEX_2] THEN
    ASM_REAL_ARITH_TAC]);;

let MEASURE_UNIT_SEMICIRCLE = prove
 (`measure {z:real^2 | &0 <= z$1 /\ z$1 <= &1 /\ norm z <= &1} = pi / &2`,
  MATCH_MP_TAC(REAL_ARITH `~(&0 < abs(x - y)) ==> x = y`) THEN DISCH_TAC THEN
  ABBREV_TAC
   `e = abs(measure {z:real^2 | &0 <= z$1 /\ z$1 <= &1 /\ norm z <= &1} -
            pi / &2)` THEN
  SUBGOAL_THEN `(\x. (asn(x) + x * sqrt(&1 - x pow 2)))
                real_continuous (atreal(&1) within {t | abs t <= &1})`
  MP_TAC THENL
   [MATCH_MP_TAC REAL_CONTINUOUS_ADD THEN
    REWRITE_TAC[REAL_CONTINUOUS_WITHIN_ASN_STRONG] THEN
    MATCH_MP_TAC REAL_CONTINUOUS_MUL THEN
    REWRITE_TAC[REAL_CONTINUOUS_WITHIN_ID] THEN
    MATCH_MP_TAC(REWRITE_RULE[o_DEF] REAL_CONTINUOUS_WITHINREAL_COMPOSE) THEN
    CONJ_TAC THENL
     [MATCH_MP_TAC REAL_DIFFERENTIABLE_IMP_CONTINUOUS_WITHINREAL THEN
      REAL_DIFFERENTIABLE_TAC;
      MATCH_MP_TAC REAL_CONTINUOUS_WITHINREAL_SUBSET THEN
      EXISTS_TAC `{t | &0 <= t}` THEN
      REWRITE_TAC[REAL_CONTINUOUS_WITHIN_SQRT_STRONG] THEN
      REWRITE_TAC[SUBSET; FORALL_IN_IMAGE; IN_ELIM_THM] THEN
      REWRITE_TAC[ABS_SQUARE_LE_1; REAL_SUB_LE]];
    ALL_TAC] THEN
  REWRITE_TAC[real_continuous_withinreal] THEN
  DISCH_THEN(MP_TAC o SPEC `e / &2`) THEN ASM_REWRITE_TAC[REAL_HALF] THEN
  REWRITE_TAC[IN_ELIM_THM; ASN_1] THEN
  DISCH_THEN(X_CHOOSE_THEN `d:real` STRIP_ASSUME_TAC) THEN
  FIRST_X_ASSUM(MP_TAC o SPEC `&1 - min (&1) (min (e / &4) (d / &2))`) THEN
  ANTS_TAC THENL [ASM_REAL_ARITH_TAC; ALL_TAC] THEN
  MP_TAC(SPEC `&1 - min (&1) (min (e / &4) (d / &2))`
    MEASURE_UNIT_SEMICIRCLE_DELTA) THEN
  ANTS_TAC THENL [ASM_REAL_ARITH_TAC; ALL_TAC] THEN
  MP_TAC(SPEC `&1 - min (&1) (min (e / &4) (d / &2))`
     MEASURE_CIRCLE_CHUNK) THEN
  ANTS_TAC THENL [ASM_REAL_ARITH_TAC; DISCH_THEN SUBST1_TAC] THEN
  CONV_TAC REAL_RAT_REDUCE_CONV THEN
  REWRITE_TAC[SQRT_0; REAL_MUL_RZERO; REAL_ADD_RID] THEN
  MATCH_MP_TAC(REAL_ARITH
   `x <= e / &2 /\ abs(m - p) = e ==> abs(m - a) <= x
    ==> ~(abs(a - p) < e / &2)`) THEN
  ASM_REWRITE_TAC[] THEN ASM_REAL_ARITH_TAC);;

(* ------------------------------------------------------------------------- *)
(* So finally the area of the unit circle.                                   *)
(* ------------------------------------------------------------------------- *)

let MEASURE_UNIT_CIRCLE = prove
 (`measure(cball(vec 0:real^2,&1)) = pi`,
  SUBGOAL_THEN `linear((\x. vector[--(x$1);x$2]):real^2->real^2)`
  ASSUME_TAC THENL
   [SIMP_TAC[linear; VECTOR_ADD_COMPONENT; VECTOR_MUL_COMPONENT;
             VECTOR_2; ARITH; DIMINDEX_2; CART_EQ; FORALL_2] THEN
    REAL_ARITH_TAC;
    ALL_TAC] THEN
  SUBGOAL_THEN
   `cball(vec 0:real^2,&1) =
        {z | &0 <= z$1 /\ z$1 <= &1 /\ norm z <= &1} UNION
        IMAGE (\x. vector[--(x$1);x$2])
              {z:real^2 | &0 <= z$1 /\ z$1 <= &1 /\ norm z <= &1}`
  SUBST1_TAC THENL
   [MATCH_MP_TAC EQ_TRANS THEN
    EXISTS_TAC `cball(vec 0,&1) INTER {z:real^2 | &0 <= z$1} UNION
                cball(vec 0,&1) INTER {z:real^2 | z$1 <= &0}` THEN
    CONJ_TAC THENL
     [REWRITE_TAC[EXTENSION; IN_INTER; IN_CBALL; IN_ELIM_THM; IN_UNION] THEN
      REAL_ARITH_TAC;
      ALL_TAC] THEN
    BINOP_TAC THEN SIMP_TAC[EXTENSION; IN_INTER; IN_CBALL_0; IN_ELIM_THM] THENL
     [X_GEN_TAC `z:real^2` THEN
      MP_TAC(ISPECL [`z:real^2`; `1`] COMPONENT_LE_NORM) THEN
      REWRITE_TAC[DIMINDEX_2; ARITH] THEN REAL_ARITH_TAC;
      ALL_TAC] THEN
    X_GEN_TAC `z:real^2` THEN EQ_TAC THENL
     [STRIP_TAC THEN REWRITE_TAC[IN_IMAGE] THEN
      EXISTS_TAC `vector[--(z$1); (z:real^2)$2]:real^2` THEN
      SIMP_TAC[CART_EQ; FORALL_2; VECTOR_2; IN_ELIM_THM; DIMINDEX_2] THEN
      ASM_REWRITE_TAC[REAL_NEG_NEG; REAL_NEG_GE0] THEN CONJ_TAC THENL
       [MP_TAC(ISPECL [`z:real^2`; `1`] COMPONENT_LE_NORM) THEN
        REWRITE_TAC[DIMINDEX_2; ARITH] THEN ASM_REAL_ARITH_TAC;
        UNDISCH_TAC `norm(z:real^2) <= &1` THEN MATCH_MP_TAC EQ_IMP THEN
        AP_THM_TAC THEN AP_TERM_TAC THEN REWRITE_TAC[NORM_EQ] THEN
        REWRITE_TAC[DOT_2; VECTOR_2] THEN REAL_ARITH_TAC];
      SPEC_TAC(`z:real^2`,`z:real^2`) THEN REWRITE_TAC[FORALL_IN_IMAGE] THEN
      X_GEN_TAC `z:real^2` THEN
      SIMP_TAC[IN_ELIM_THM; VECTOR_2; REAL_NEG_LE0] THEN
      DISCH_THEN(MP_TAC o last o CONJUNCTS) THEN MATCH_MP_TAC EQ_IMP THEN
      AP_THM_TAC THEN AP_TERM_TAC THEN REWRITE_TAC[NORM_EQ] THEN
      REWRITE_TAC[DOT_2; VECTOR_2] THEN REAL_ARITH_TAC];
    ALL_TAC] THEN
  W(MP_TAC o PART_MATCH (lhs o rand) MEASURE_NEGLIGIBLE_UNION o lhs o snd) THEN
  ANTS_TAC THENL
   [ASM_SIMP_TAC[MEASURABLE_LINEAR_IMAGE; MEASURABLE_CIRCLE_CHUNK] THEN
    MATCH_MP_TAC NEGLIGIBLE_SUBSET THEN EXISTS_TAC `{z:real^2 | z$1 = &0}` THEN
    SIMP_TAC[NEGLIGIBLE_STANDARD_HYPERPLANE; DIMINDEX_2; ARITH] THEN
    REWRITE_TAC[SUBSET; IN_INTER; IMP_CONJ_ALT] THEN
    REWRITE_TAC[FORALL_IN_IMAGE; IN_ELIM_THM] THEN
    SIMP_TAC[VECTOR_2] THEN REAL_ARITH_TAC;
    ALL_TAC] THEN
  DISCH_THEN SUBST1_TAC THEN MATCH_MP_TAC(REAL_ARITH
   `x = p / &2 /\ y = x ==> x + y = p`) THEN
  CONJ_TAC THENL [REWRITE_TAC[MEASURE_UNIT_SEMICIRCLE]; ALL_TAC] THEN
  MATCH_MP_TAC MEASURE_LINEAR_IMAGE_SAME THEN
  ASM_REWRITE_TAC[MEASURABLE_CIRCLE_CHUNK] THEN
  SIMP_TAC[DET_2; matrix; LAMBDA_BETA; DIMINDEX_2; ARITH; VECTOR_2;
           BASIS_COMPONENT] THEN
  CONV_TAC REAL_RAT_REDUCE_CONV);;

(* ------------------------------------------------------------------------- *)
(* Hence the general circle.                                                 *)
(* ------------------------------------------------------------------------- *)

let MEASURE_CIRCLE = prove
 (`!z:real^2 r. &0 <= r ==> measure(cball(z,r)) = pi * r pow 2`,
  REPEAT STRIP_TAC THEN ASM_CASES_TAC `r = &0` THENL
   [ASM_SIMP_TAC[CBALL_SING; REAL_POW_2; REAL_MUL_RZERO] THEN
    MATCH_MP_TAC MEASURE_UNIQUE THEN
    REWRITE_TAC[HAS_MEASURE_0; NEGLIGIBLE_SING];
    ALL_TAC] THEN
  SUBGOAL_THEN `&0 < r` ASSUME_TAC THENL [ASM_REAL_ARITH_TAC; ALL_TAC] THEN
  MP_TAC(ISPECL [`cball(vec 0:real^2,&1)`; `r:real`; `z:real^2`; `pi`]
        HAS_MEASURE_AFFINITY) THEN
  REWRITE_TAC[HAS_MEASURE_MEASURABLE_MEASURE; MEASURABLE_CBALL;
              MEASURE_UNIT_CIRCLE] THEN
  ASM_REWRITE_TAC[real_abs; DIMINDEX_2] THEN
  DISCH_THEN(MP_TAC o CONJUNCT2) THEN
  GEN_REWRITE_TAC (LAND_CONV o ONCE_DEPTH_CONV) [REAL_MUL_SYM] THEN
  DISCH_THEN(SUBST1_TAC o SYM) THEN AP_TERM_TAC THEN
  MATCH_MP_TAC SUBSET_ANTISYM THEN REWRITE_TAC[SUBSET; FORALL_IN_IMAGE] THEN
  REWRITE_TAC[IN_CBALL_0; IN_IMAGE] THEN REWRITE_TAC[IN_CBALL] THEN
  REWRITE_TAC[NORM_ARITH `dist(z,a + z) = norm a`; NORM_MUL] THEN
  ONCE_REWRITE_TAC[REAL_ARITH `abs r * x <= r <=> abs r * x <= r * &1`] THEN
  ASM_SIMP_TAC[real_abs; REAL_LE_LMUL; dist] THEN X_GEN_TAC `w:real^2` THEN
  DISCH_TAC THEN EXISTS_TAC `inv(r) % (w - z):real^2` THEN
  ASM_SIMP_TAC[VECTOR_MUL_ASSOC; REAL_MUL_RINV] THEN
  CONJ_TAC THENL [NORM_ARITH_TAC; ALL_TAC] THEN
  REWRITE_TAC[NORM_MUL; REAL_ABS_INV] THEN ASM_REWRITE_TAC[real_abs] THEN
  ONCE_REWRITE_TAC[REAL_MUL_SYM] THEN
  ASM_SIMP_TAC[GSYM real_div; REAL_LE_LDIV_EQ; REAL_MUL_LID] THEN
  ONCE_REWRITE_TAC[NORM_SUB] THEN ASM_REWRITE_TAC[]);;

(* ------------------------------------------------------------------------- *)
(* A more explicit version.                                                  *)
(* ------------------------------------------------------------------------- *)

let AREA_OF_CIRCLE = prove
 (`!a:real^2 r.
        measurable {z | dist(a,z) <= r} /\
        (&0 <= r ==> measure {z | dist(a,z) <= r} = pi * r pow 2)`,
  REWRITE_TAC[GSYM cball; MEASURABLE_CBALL; MEASURE_CIRCLE]);;
