(* ========================================================================= *)
(* Arithmetic-geometric mean inequality.                                     *)
(* ========================================================================= *)

needs "Examples/agm.ml";;
needs "Examples/transc.ml";;

prioritize_real();;

(* ------------------------------------------------------------------------- *)
(* All we do is reformulate in the usual way using roots.                    *)
(* ------------------------------------------------------------------------- *)

let AGM_ROOT = prove
 (`!n a. 1 <= n /\ (!i. 1 <= i /\ i <= n ==> &0 <= a(i))
         ==> root n (product(1..n) a) <= sum(1..n) a / &n`,
  INDUCT_TAC THEN REWRITE_TAC[ARITH; ARITH_RULE `1 <= SUC n`] THEN
  REPEAT STRIP_TAC THEN MATCH_MP_TAC REAL_LE_TRANS THEN
  EXISTS_TAC `root(SUC n) ((sum(1..SUC n) a / &(SUC n)) pow (SUC n))` THEN
  CONJ_TAC THENL
   [MATCH_MP_TAC ROOT_MONO_LE THEN
    ASM_SIMP_TAC[AGM; ARITH_RULE `1 <= SUC n`] THEN
    MATCH_MP_TAC PRODUCT_POS_LE THEN
    ASM_REWRITE_TAC[IN_NUMSEG; FINITE_NUMSEG];
    MATCH_MP_TAC REAL_EQ_IMP_LE THEN MATCH_MP_TAC POW_ROOT_POS THEN
    ASM_SIMP_TAC[REAL_LE_DIV; REAL_POS; SUM_POS_LE_NUMSEG]]);;
