/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Vector2i;
import org.joml.Vector3i;

public class Vector4i
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;
    public int w = 1;

    public Vector4i() {
    }

    public Vector4i(Vector4i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public Vector4i(Vector3i v, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public Vector4i(Vector2i v, int z, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(int s) {
        this.x = s;
        this.y = s;
        this.z = s;
        this.w = s;
    }

    public Vector4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index + 0);
        this.y = buffer.getInt(index + 4);
        this.z = buffer.getInt(index + 8);
        this.w = buffer.getInt(index + 12);
    }

    public Vector4i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, IntBuffer buffer) {
        this.x = buffer.get(index + 0);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        this.w = buffer.get(index + 3);
    }

    public Vector4i set(Vector4i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public Vector4i set(Vector3i v, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
        return this;
    }

    public Vector4i set(Vector2i v, int z, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(int s) {
        this.x = s;
        this.y = s;
        this.z = s;
        this.w = s;
        return this;
    }

    public Vector4i set(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index);
        this.y = buffer.getInt(index + 4);
        this.z = buffer.getInt(index + 8);
        this.w = buffer.getInt(index + 12);
        return this;
    }

    public Vector4i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, IntBuffer buffer) {
        this.x = buffer.get(index + 0);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        this.w = buffer.get(index + 3);
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        buffer.put(index + 0, this.x);
        buffer.put(index + 1, this.y);
        buffer.put(index + 2, this.z);
        buffer.put(index + 3, this.w);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putInt(index, this.x);
        buffer.putInt(index + 4, this.y);
        buffer.putInt(index + 8, this.z);
        buffer.putInt(index + 12, this.w);
        return buffer;
    }

    public Vector4i sub(Vector4i v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.w -= v.w;
        return this;
    }

    public Vector4i sub(int x, int y, int z, int w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    public Vector4i sub(Vector4i v, Vector4i dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        dest.z = this.z - v.z;
        dest.w = this.w - v.w;
        return dest;
    }

    public Vector4i sub(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4i add(Vector4i v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.w += v.w;
        return this;
    }

    public Vector4i add(Vector4i v, Vector4i dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        dest.z = this.z + v.z;
        dest.w = this.w + v.w;
        return dest;
    }

    public Vector4i add(int x, int y, int z, int w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    public Vector4i add(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4i mul(Vector4i v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        this.w *= v.w;
        return this;
    }

    public Vector4i mul(Vector4i v, Vector4i dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        dest.z = this.z * v.z;
        dest.w = this.w * v.w;
        return dest;
    }

    public Vector4i div(Vector4i v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        this.w /= v.w;
        return this;
    }

    public Vector4i div(Vector4i v, Vector4i dest) {
        dest.x = this.x / v.x;
        dest.y = this.y / v.y;
        dest.z = this.z / v.z;
        dest.w = this.w / v.w;
        return dest;
    }

    public Vector4i mul(float scalar) {
        this.x = (int)((float)this.x * scalar);
        this.y = (int)((float)this.y * scalar);
        this.z = (int)((float)this.z * scalar);
        this.w = (int)((float)this.w * scalar);
        return this;
    }

    public Vector4i mul(float scalar, Vector4i dest) {
        dest.x = (int)((float)this.x * scalar);
        dest.y = (int)((float)this.y * scalar);
        dest.z = (int)((float)this.z * scalar);
        dest.w = (int)((float)this.w * scalar);
        return dest;
    }

    public Vector4i div(int scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.w /= scalar;
        return this;
    }

    public Vector4i div(float scalar, Vector4i dest) {
        dest.x = (int)((float)this.x / scalar);
        dest.y = (int)((float)this.y / scalar);
        dest.z = (int)((float)this.z / scalar);
        dest.w = (int)((float)this.w / scalar);
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector4i v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y, int z, int w) {
        return Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    public int distanceSquared(Vector4i v) {
        int dx = this.x - v.x;
        int dy = this.y - v.y;
        int dz = this.z - v.z;
        int dw = this.w - v.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public int distanceSquared(int x, int y, int z, int w) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        int dw = this.w - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public int dot(Vector4i v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public Vector4i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.w = 0;
        return this;
    }

    public Vector4i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4i negate(Vector4i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        return "(" + this.x + " " + this.y + " " + this.z + " " + this.w + ")";
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeInt(this.w);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.w = in.readInt();
    }

    public Vector4i min(Vector4i v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
        this.w = Math.min(this.w, v.w);
        return this;
    }

    public Vector4i max(Vector4i v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
        this.w = Math.min(this.w, v.w);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.w;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4i other = (Vector4i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        return this.w == other.w;
    }
}

