/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Vector3d
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d) {
        this(d, d, d);
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3d(Vector2f v, double z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
    }

    public Vector3d(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3d(Vector2d v, double z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
    }

    public Vector3d(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, ByteBuffer buffer) {
        this.x = buffer.getDouble(index);
        this.y = buffer.getDouble(index + 8);
        this.z = buffer.getDouble(index + 16);
    }

    public Vector3d(DoubleBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, DoubleBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
    }

    public Vector3d set(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vector3d set(Vector2d v, double z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        return this;
    }

    public Vector3d set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vector3d set(Vector2f v, double z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        return this;
    }

    public Vector3d set(double d) {
        return this.set(d, d, d);
    }

    public Vector3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3d set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, ByteBuffer buffer) {
        this.x = buffer.getDouble(index);
        this.y = buffer.getDouble(index + 8);
        this.z = buffer.getDouble(index + 16);
        return this;
    }

    public Vector3d set(DoubleBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, DoubleBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putDouble(index, this.x);
        buffer.putDouble(index + 8, this.y);
        buffer.putDouble(index + 16, this.z);
        return buffer;
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        buffer.put(index, this.x);
        buffer.put(index + 1, this.y);
        buffer.put(index + 2, this.z);
        return buffer;
    }

    public Vector3d sub(Vector3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector3d sub(Vector3d v, Vector3d dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        dest.z = this.z - v.z;
        return dest;
    }

    public Vector3d sub(Vector3f v) {
        this.x -= (double)v.x;
        this.y -= (double)v.y;
        this.z -= (double)v.z;
        return this;
    }

    public Vector3d sub(Vector3f v, Vector3d dest) {
        dest.x = this.x - (double)v.x;
        dest.y = this.y - (double)v.y;
        dest.z = this.z - (double)v.z;
        return dest;
    }

    public Vector3d sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3d sub(double x, double y, double z, Vector3d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3d add(Vector3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3d add(Vector3d v, Vector3d dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        dest.z = this.z + v.z;
        return dest;
    }

    public Vector3d add(Vector3f v) {
        this.x += (double)v.x;
        this.y += (double)v.y;
        this.z += (double)v.z;
        return this;
    }

    public Vector3d add(Vector3f v, Vector3d dest) {
        dest.x = this.x + (double)v.x;
        dest.y = this.y + (double)v.y;
        dest.z = this.z + (double)v.z;
        return dest;
    }

    public Vector3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3d add(double x, double y, double z, Vector3d dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3d fma(Vector3d a, Vector3d b) {
        this.x += a.x * b.x;
        this.y += a.y * b.y;
        this.z += a.z * b.z;
        return this;
    }

    public Vector3d fma(double a, Vector3d b) {
        this.x += a * b.x;
        this.y += a * b.y;
        this.z += a * b.z;
        return this;
    }

    public Vector3d fma(Vector3f a, Vector3f b) {
        this.x += (double)(a.x * b.x);
        this.y += (double)(a.y * b.y);
        this.z += (double)(a.z * b.z);
        return this;
    }

    public Vector3d fma(double a, Vector3f b) {
        this.x += a * (double)b.x;
        this.y += a * (double)b.y;
        this.z += a * (double)b.z;
        return this;
    }

    public Vector3d fma(Vector3d a, Vector3d b, Vector3d dest) {
        dest.x = this.x + a.x * b.x;
        dest.y = this.y + a.y * b.y;
        dest.z = this.z + a.z * b.z;
        return dest;
    }

    public Vector3d fma(double a, Vector3d b, Vector3d dest) {
        dest.x = this.x + a * b.x;
        dest.y = this.y + a * b.y;
        dest.z = this.z + a * b.z;
        return dest;
    }

    public Vector3d fma(Vector3d a, Vector3f b, Vector3d dest) {
        dest.x = this.x + a.x * (double)b.x;
        dest.y = this.y + a.y * (double)b.y;
        dest.z = this.z + a.z * (double)b.z;
        return dest;
    }

    public Vector3d fma(double a, Vector3f b, Vector3d dest) {
        dest.x = this.x + a * (double)b.x;
        dest.y = this.y + a * (double)b.y;
        dest.z = this.z + a * (double)b.z;
        return dest;
    }

    public Vector3d mul(Vector3d v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public Vector3d mul(Vector3f v) {
        this.x *= (double)v.x;
        this.y *= (double)v.y;
        this.z *= (double)v.z;
        return this;
    }

    public Vector3d mul(Vector3f v, Vector3d dest) {
        dest.x = this.x * (double)v.x;
        dest.y = this.y * (double)v.y;
        dest.z = this.z * (double)v.z;
        return dest;
    }

    public Vector3d mul(Vector3d v, Vector3d dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        dest.z = this.z * v.z;
        return dest;
    }

    public Vector3d div(Vector3d v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public Vector3d div(Vector3f v) {
        this.x /= (double)v.x;
        this.y /= (double)v.y;
        this.z /= (double)v.z;
        return this;
    }

    public Vector3d div(Vector3f v, Vector3d dest) {
        dest.x = this.x / (double)v.x;
        dest.y = this.y / (double)v.y;
        dest.z = this.z / (double)v.z;
        return dest;
    }

    public Vector3d div(Vector3d v, Vector3d dest) {
        dest.x = this.x / v.x;
        dest.y = this.y / v.y;
        dest.z = this.z / v.z;
        return dest;
    }

    public Vector3d mulProject(Matrix4d mat, Vector3d dest) {
        double invW = 1.0 / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33());
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30()) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31()) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32()) * invW);
        return dest;
    }

    public Vector3d mulProject(Matrix4d mat) {
        return this.mulProject(mat, this);
    }

    public Vector3d mulProject(Matrix4f mat, Vector3d dest) {
        double invW = 1.0 / ((double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33());
        dest.set(((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30()) * invW, ((double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31()) * invW, ((double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32()) * invW);
        return dest;
    }

    public Vector3d mulProject(Matrix4f mat) {
        return this.mulProject(mat, this);
    }

    public Vector3d mul(Matrix3f mat) {
        return this.mul(mat, this);
    }

    public Vector3d mul(Matrix3d mat) {
        return this.mul(mat, this);
    }

    public Vector3d mul(Matrix3d mat, Vector3d dest) {
        dest.set(mat.m00 * this.x + mat.m10 * this.y + mat.m20 * this.z, mat.m01 * this.x + mat.m11 * this.y + mat.m21 * this.z, mat.m02 * this.x + mat.m12 * this.y + mat.m22 * this.z);
        return dest;
    }

    public Vector3d mul(Matrix3f mat, Vector3d dest) {
        dest.set((double)mat.m00 * this.x + (double)mat.m10 * this.y + (double)mat.m20 * this.z, (double)mat.m01 * this.x + (double)mat.m11 * this.y + (double)mat.m21 * this.z, (double)mat.m02 * this.x + (double)mat.m12 * this.y + (double)mat.m22 * this.z);
        return dest;
    }

    public Vector3d mulPosition(Matrix4f mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4d mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4d mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return dest;
    }

    public Vector3d mulPosition(Matrix4f mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30(), (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31(), (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32());
        return dest;
    }

    public double mulPositionW(Matrix4f mat) {
        return this.mulPositionW(mat, this);
    }

    public double mulPositionW(Matrix4f mat, Vector3d dest) {
        double w = (double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33();
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30(), (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31(), (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32());
        return w;
    }

    public double mulPositionW(Matrix4d mat) {
        return this.mulPositionW(mat, this);
    }

    public double mulPositionW(Matrix4d mat, Vector3d dest) {
        double w = mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33();
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return w;
    }

    public Vector3d mulDirection(Matrix4f mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4d mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4d mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulDirection(Matrix4f mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3d mul(double scalar, Vector3d dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        return dest;
    }

    public Vector3d mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3d mul(double x, double y, double z, Vector3d dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public Vector3d rotate(Quaterniond quat) {
        quat.transform(this, this);
        return this;
    }

    public Vector3d rotate(Quaterniond quat, Vector3d dest) {
        quat.transform(this, dest);
        return dest;
    }

    public Quaterniond rotationTo(Vector3d toDir, Quaterniond dest) {
        return dest.rotationTo(this, toDir);
    }

    public Quaterniond rotationTo(double toDirX, double toDirY, double toDirZ, Quaterniond dest) {
        return dest.rotationTo(this.x, this.y, this.z, toDirX, toDirY, toDirZ);
    }

    public Vector3d div(double scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        return this;
    }

    public Vector3d div(double scalar, Vector3d dest) {
        dest.x = this.x / scalar;
        dest.y = this.y / scalar;
        dest.z = this.z / scalar;
        return dest;
    }

    public Vector3d div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3d div(double x, double y, double z, Vector3d dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        return dest;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Vector3d normalize() {
        double invLength = 1.0 / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        return this;
    }

    public Vector3d normalize(Vector3d dest) {
        double invLength = 1.0 / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        return dest;
    }

    public Vector3d cross(Vector3d v) {
        this.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        return this;
    }

    public Vector3d cross(double x, double y, double z) {
        return this.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public Vector3d cross(Vector3d v, Vector3d dest) {
        dest.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        return dest;
    }

    public Vector3d cross(double x, double y, double z, Vector3d dest) {
        return dest.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public double distance(Vector3d v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        double dz = v.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSquared(Vector3d v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        double dz = v.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSquared(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double dot(Vector3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public double angleCos(Vector3d v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z;
        double length2Sqared = v.x * v.x + v.y * v.y + v.z * v.z;
        double dot = this.x * v.x + this.y * v.y + this.z * v.z;
        return dot / Math.sqrt(length1Sqared * length2Sqared);
    }

    public double angle(Vector3d v) {
        double cos = this.angleCos(v);
        cos = cos < 1.0 ? cos : 1.0;
        cos = cos > -1.0 ? cos : -1.0;
        return Math.acos(cos);
    }

    public Vector3d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public Vector3d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3d negate(Vector3d dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3d other = (Vector3d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public Vector3d reflect(Vector3d normal) {
        double dot = this.dot(normal);
        this.x -= (dot + dot) * normal.x;
        this.y -= (dot + dot) * normal.y;
        this.z -= (dot + dot) * normal.z;
        return this;
    }

    public Vector3d reflect(double x, double y, double z) {
        double dot = this.dot(x, y, z);
        this.x -= (dot + dot) * x;
        this.y -= (dot + dot) * y;
        this.z -= (dot + dot) * z;
        return this;
    }

    public Vector3d reflect(Vector3d normal, Vector3d dest) {
        double dot = this.dot(normal);
        dest.x = this.x - (dot + dot) * normal.x;
        dest.y = this.y - (dot + dot) * normal.y;
        dest.z = this.z - (dot + dot) * normal.z;
        return dest;
    }

    public Vector3d reflect(double x, double y, double z, Vector3d dest) {
        double dot = this.dot(x, y, z);
        dest.x = this.x - (dot + dot) * x;
        dest.y = this.y - (dot + dot) * y;
        dest.z = this.z - (dot + dot) * z;
        return dest;
    }

    public Vector3d half(Vector3d other) {
        return this.add(other).normalize();
    }

    public Vector3d half(double x, double y, double z) {
        return this.add(x, y, z).normalize();
    }

    public Vector3d half(Vector3d other, Vector3d dest) {
        return dest.set(this).add(other).normalize();
    }

    public Vector3d half(double x, double y, double z, Vector3d dest) {
        return dest.set(this).add(x, y, z).normalize();
    }

    public Vector3d smoothStep(Vector3d v, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v.x - v.x) * t3 + (3.0 * v.x - 3.0 * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y - v.y) * t3 + (3.0 * v.y - 3.0 * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z - v.z) * t3 + (3.0 * v.z - 3.0 * this.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d hermite(Vector3d t0, Vector3d v1, Vector3d t1, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x - v1.x + t1.x + t0.x) * t3 + (3.0 * v1.x - 3.0 * this.x - t0.x - t0.x - t1.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y - v1.y + t1.y + t0.y) * t3 + (3.0 * v1.y - 3.0 * this.y - t0.y - t0.y - t1.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z - v1.z + t1.z + t0.z) * t3 + (3.0 * v1.z - 3.0 * this.z - t0.z - t0.z - t1.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d lerp(Vector3d other, double t) {
        return this.lerp(other, t, this);
    }

    public Vector3d lerp(Vector3d other, double t, Vector3d dest) {
        dest.x = this.x + (other.x - this.x) * t;
        dest.y = this.y + (other.y - this.y) * t;
        dest.z = this.z + (other.z - this.z) * t;
        return dest;
    }

    public double get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3d set(int component, double value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public int maxComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX >= absY && absX >= absZ) {
            return 0;
        }
        if (absY >= absZ) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX < absY && absX < absZ) {
            return 0;
        }
        if (absY < absZ) {
            return 1;
        }
        return 2;
    }
}

