/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandPoolCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;

    VkCommandPoolCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkCommandPoolCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCommandPoolCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkCommandPoolCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkCommandPoolCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkCommandPoolCreateInfo.nflags(this.address());
    }

    public int queueFamilyIndex() {
        return VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address());
    }

    public VkCommandPoolCreateInfo sType(int value) {
        VkCommandPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo pNext(long value) {
        VkCommandPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo flags(int value) {
        VkCommandPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo queueFamilyIndex(int value) {
        VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo set(int sType, long pNext, int flags, int queueFamilyIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        return this;
    }

    public VkCommandPoolCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkCommandPoolCreateInfo set(VkCommandPoolCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkCommandPoolCreateInfo malloc() {
        return VkCommandPoolCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkCommandPoolCreateInfo calloc() {
        return VkCommandPoolCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkCommandPoolCreateInfo create() {
        return new VkCommandPoolCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCommandPoolCreateInfo create(long address) {
        return address == 0L ? null : new VkCommandPoolCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandPoolCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandPoolCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkCommandPoolCreateInfo mallocStack() {
        return VkCommandPoolCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandPoolCreateInfo callocStack() {
        return VkCommandPoolCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkCommandPoolCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandPoolCreateInfo callocStack(MemoryStack stack) {
        return VkCommandPoolCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandPoolCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandPoolCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandPoolCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandPoolCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nqueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEX, value);
    }

    static {
        Struct.Layout layout = VkCommandPoolCreateInfo.__struct(VkCommandPoolCreateInfo.__member(4), VkCommandPoolCreateInfo.__member(POINTER_SIZE), VkCommandPoolCreateInfo.__member(4), VkCommandPoolCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<VkCommandPoolCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCommandPoolCreateInfo newInstance(long address) {
            return new VkCommandPoolCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkCommandPoolCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkCommandPoolCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkCommandPoolCreateInfo.nflags(this.address());
        }

        public int queueFamilyIndex() {
            return VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address());
        }

        public Buffer sType(int value) {
            VkCommandPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkCommandPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkCommandPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(int value) {
            VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address(), value);
            return this;
        }
    }
}

