/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRErrorInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESULT;
    public static final int ERRORSTRING;

    OVRErrorInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRErrorInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRErrorInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Result() {
        return OVRErrorInfo.nResult(this.address());
    }

    public ByteBuffer ErrorString() {
        return OVRErrorInfo.nErrorString(this.address());
    }

    public String ErrorStringString() {
        return OVRErrorInfo.nErrorStringString(this.address());
    }

    public static OVRErrorInfo malloc() {
        return OVRErrorInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRErrorInfo calloc() {
        return OVRErrorInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRErrorInfo create() {
        return new OVRErrorInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRErrorInfo create(long address) {
        return address == 0L ? null : new OVRErrorInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRErrorInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRErrorInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRErrorInfo mallocStack() {
        return OVRErrorInfo.mallocStack(MemoryStack.stackGet());
    }

    public static OVRErrorInfo callocStack() {
        return OVRErrorInfo.callocStack(MemoryStack.stackGet());
    }

    public static OVRErrorInfo mallocStack(MemoryStack stack) {
        return OVRErrorInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRErrorInfo callocStack(MemoryStack stack) {
        return OVRErrorInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRErrorInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRErrorInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRErrorInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRErrorInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nResult(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESULT);
    }

    public static ByteBuffer nErrorString(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ERRORSTRING, 512);
    }

    public static String nErrorStringString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)ERRORSTRING);
    }

    static {
        Struct.Layout layout = OVRErrorInfo.__struct(OVRErrorInfo.__member(4), OVRErrorInfo.__array(1, 512));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESULT = layout.offsetof(0);
        ERRORSTRING = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRErrorInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRErrorInfo newInstance(long address) {
            return new OVRErrorInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Result() {
            return OVRErrorInfo.nResult(this.address());
        }

        public ByteBuffer ErrorString() {
            return OVRErrorInfo.nErrorString(this.address());
        }

        public String ErrorStringString() {
            return OVRErrorInfo.nErrorStringString(this.address());
        }
    }
}

