/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawElementsBaseVertex {
    protected EXTDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glDrawElementsBaseVertexEXT, ext.contains("GLES30") ? caps.glDrawRangeElementsBaseVertexEXT : -1L, ext.contains("GLES30") ? caps.glDrawElementsInstancedBaseVertexEXT : -1L, ext.contains("GL_EXT_multi_draw_arrays") ? caps.glMultiDrawElementsBaseVertexEXT : -1L);
    }

    public static void nglDrawElementsBaseVertexEXT(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawRangeElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, IntBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertexEXT(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertexEXT(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        EXTDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertexEXT(int mode, int[] count, int type, PointerBuffer indices, int[] basevertex) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indices, count.length);
            Checks.checkBuffer(basevertex, count.length);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length, basevertex);
    }
}

