/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;

    protected GL20() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glCreateProgram, caps.glDeleteProgram, caps.glIsProgram, caps.glCreateShader, caps.glDeleteShader, caps.glIsShader, caps.glAttachShader, caps.glDetachShader, caps.glShaderSource, caps.glCompileShader, caps.glLinkProgram, caps.glUseProgram, caps.glValidateProgram, caps.glUniform1f, caps.glUniform2f, caps.glUniform3f, caps.glUniform4f, caps.glUniform1i, caps.glUniform2i, caps.glUniform3i, caps.glUniform4i, caps.glUniform1fv, caps.glUniform2fv, caps.glUniform3fv, caps.glUniform4fv, caps.glUniform1iv, caps.glUniform2iv, caps.glUniform3iv, caps.glUniform4iv, caps.glUniformMatrix2fv, caps.glUniformMatrix3fv, caps.glUniformMatrix4fv, caps.glGetShaderiv, caps.glGetProgramiv, caps.glGetShaderInfoLog, caps.glGetProgramInfoLog, caps.glGetAttachedShaders, caps.glGetUniformLocation, caps.glGetActiveUniform, caps.glGetUniformfv, caps.glGetUniformiv, caps.glGetShaderSource, caps.glVertexAttrib1f, caps.glVertexAttrib1s, caps.glVertexAttrib1d, caps.glVertexAttrib2f, caps.glVertexAttrib2s, caps.glVertexAttrib2d, caps.glVertexAttrib3f, caps.glVertexAttrib3s, caps.glVertexAttrib3d, caps.glVertexAttrib4f, caps.glVertexAttrib4s, caps.glVertexAttrib4d, caps.glVertexAttrib4Nub, caps.glVertexAttrib1fv, caps.glVertexAttrib1sv, caps.glVertexAttrib1dv, caps.glVertexAttrib2fv, caps.glVertexAttrib2sv, caps.glVertexAttrib2dv, caps.glVertexAttrib3fv, caps.glVertexAttrib3sv, caps.glVertexAttrib3dv, caps.glVertexAttrib4fv, caps.glVertexAttrib4sv, caps.glVertexAttrib4dv, caps.glVertexAttrib4iv, caps.glVertexAttrib4bv, caps.glVertexAttrib4ubv, caps.glVertexAttrib4usv, caps.glVertexAttrib4uiv, caps.glVertexAttrib4Nbv, caps.glVertexAttrib4Nsv, caps.glVertexAttrib4Niv, caps.glVertexAttrib4Nubv, caps.glVertexAttrib4Nusv, caps.glVertexAttrib4Nuiv, caps.glVertexAttribPointer, caps.glEnableVertexAttribArray, caps.glDisableVertexAttribArray, caps.glBindAttribLocation, caps.glGetActiveAttrib, caps.glGetAttribLocation, caps.glGetVertexAttribiv, caps.glGetVertexAttribfv, caps.glGetVertexAttribdv, caps.glGetVertexAttribPointerv, caps.glDrawBuffers, caps.glBlendEquationSeparate, caps.glStencilOpSeparate, caps.glStencilFuncSeparate, caps.glStencilMaskSeparate);
    }

    public static int glCreateProgram() {
        long __functionAddress = GL.getCapabilities().glCreateProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void glDeleteProgram(int program) {
        long __functionAddress = GL.getCapabilities().glDeleteProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program);
    }

    public static boolean glIsProgram(int program) {
        long __functionAddress = GL.getCapabilities().glIsProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, program);
    }

    public static int glCreateShader(int type) {
        long __functionAddress = GL.getCapabilities().glCreateShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, type);
    }

    public static void glDeleteShader(int shader) {
        long __functionAddress = GL.getCapabilities().glDeleteShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, shader);
    }

    public static boolean glIsShader(int shader) {
        long __functionAddress = GL.getCapabilities().glIsShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, shader);
    }

    public static void glAttachShader(int program, int shader) {
        long __functionAddress = GL.getCapabilities().glAttachShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, shader);
    }

    public static void glDetachShader(int program, int shader) {
        long __functionAddress = GL.getCapabilities().glDetachShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, shader);
    }

    public static void nglShaderSource(int shader, int count, long strings, long length) {
        long __functionAddress = GL.getCapabilities().glShaderSource;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shader, count, strings, length);
    }

    public static void glShaderSource(int shader, PointerBuffer strings, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, strings.remaining());
        }
        GL20.nglShaderSource(shader, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayi(stack, MemoryUtil::memUTF8, strings);
            GL20.nglShaderSource(shader, strings.length, stringsAddress, stringsAddress - (long)(strings.length << 2));
            APIUtil.apiArrayFree(stringsAddress, strings.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayi(stack, MemoryUtil::memUTF8, string);
            GL20.nglShaderSource(shader, 1, stringsAddress, stringsAddress - 4L);
            APIUtil.apiArrayFree(stringsAddress, 1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glCompileShader(int shader) {
        long __functionAddress = GL.getCapabilities().glCompileShader;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, shader);
    }

    public static void glLinkProgram(int program) {
        long __functionAddress = GL.getCapabilities().glLinkProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program);
    }

    public static void glUseProgram(int program) {
        long __functionAddress = GL.getCapabilities().glUseProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program);
    }

    public static void glValidateProgram(int program) {
        long __functionAddress = GL.getCapabilities().glValidateProgram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program);
    }

    public static void glUniform1f(int location, float v0) {
        long __functionAddress = GL.getCapabilities().glUniform1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0);
    }

    public static void glUniform2f(int location, float v0, float v1) {
        long __functionAddress = GL.getCapabilities().glUniform2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        long __functionAddress = GL.getCapabilities().glUniform3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL.getCapabilities().glUniform4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void glUniform1i(int location, int v0) {
        long __functionAddress = GL.getCapabilities().glUniform1i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0);
    }

    public static void glUniform2i(int location, int v0, int v1) {
        long __functionAddress = GL.getCapabilities().glUniform2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        long __functionAddress = GL.getCapabilities().glUniform3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL.getCapabilities().glUniform4i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform1fv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fv(int location, FloatBuffer value) {
        GL20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2fv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fv(int location, FloatBuffer value) {
        GL20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3fv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fv(int location, FloatBuffer value) {
        GL20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4fv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fv(int location, FloatBuffer value) {
        GL20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniform1iv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1iv(int location, IntBuffer value) {
        GL20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2iv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2iv(int location, IntBuffer value) {
        GL20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3iv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3iv(int location, IntBuffer value) {
        GL20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4iv(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4iv(int location, IntBuffer value) {
        GL20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetShaderiv(int shader, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shader, pname, params);
    }

    public static void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetShaderi(int shader, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramiv(int program, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, pname, params);
    }

    public static void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgrami(int program, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderInfoLog(int shader, int maxLength, long length, long infoLog) {
        long __functionAddress = GL.getCapabilities().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shader, maxLength, length, infoLog);
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetShaderInfoLog(shader, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetShaderInfoLog(shader, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramInfoLog(int program, int maxLength, long length, long infoLog) {
        long __functionAddress = GL.getCapabilities().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, maxLength, length, infoLog);
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetProgramInfoLog(program, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program) {
        int maxLength = GL20.glGetProgrami(program, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetProgramInfoLog(program, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetAttachedShaders(int program, int maxCount, long count, long shaders) {
        long __functionAddress = GL.getCapabilities().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, maxCount, count, shaders);
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        GL20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static int nglGetUniformLocation(int program, long name) {
        long __functionAddress = GL.getCapabilities().glGetUniformLocation;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetUniformLocation(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL20.nglGetUniformLocation(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniform(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, program, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GL20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int maxLength = GL20.glGetProgrami(program, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformfv(int program, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformfv(int program, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformiv(int program, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderSource(int shader, int maxLength, long length, long source) {
        long __functionAddress = GL.getCapabilities().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shader, maxLength, length, source);
    }

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetShaderSource(shader, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35720);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            GL20.nglGetShaderSource(shader, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    public static void glVertexAttrib1f(int index, float v0) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib1s(int index, short v0) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib1d(int index, double v0) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib2f(int index, float v0, float v1) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib2s(int index, short v0, short v1) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib2d(int index, double v0, double v1) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib3f(int index, float v0, float v1, float v2) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib3s(int index, short v0, short v1, short v2) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib3d(int index, double v0, double v1, double v2) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4s(int index, short v0, short v1, short v2, short v3) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4d(int index, double v0, double v1, double v2, double v3) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nub;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttrib1fv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib1sv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib1dv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2fv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2sv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2dv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3fv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3sv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3dv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4fv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4sv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4dv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4iv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4iv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4iv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4bv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4bv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4bv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4bv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4ubv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4ubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4ubv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4ubv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4usv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4usv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4usv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4uiv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4uiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nbv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nbv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nbv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nbv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nsv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nsv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nsv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Niv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Niv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Niv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Niv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nubv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nubv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nubv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nusv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nusv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nusv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nuiv(int index, long v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nuiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nuiv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glEnableVertexAttribArray(int index) {
        long __functionAddress = GL.getCapabilities().glEnableVertexAttribArray;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index);
    }

    public static void glDisableVertexAttribArray(int index) {
        long __functionAddress = GL.getCapabilities().glDisableVertexAttribArray;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index);
    }

    public static void nglBindAttribLocation(int program, int index, long name) {
        long __functionAddress = GL.getCapabilities().glBindAttribLocation;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, index, name);
    }

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        GL20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            GL20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveAttrib(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, program, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GL20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int maxLength = GL20.glGetProgrami(program, 35722);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetAttribLocation(int program, long name) {
        long __functionAddress = GL.getCapabilities().glGetAttribLocation;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetAttribLocation(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetAttribLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL20.nglGetAttribLocation(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexAttribiv(int index, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexAttribi(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexAttribfv(int index, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribdv(int index, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribdv(int index, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribPointerv(int index, int pname, long pointer) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribPointerv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, pname, pointer);
    }

    public static void glGetVertexAttribPointerv(int index, int pname, PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pointer, 1);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexAttribPointer(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pointer = stack.callocPointer(1);
            GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
            long l = pointer.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDrawBuffers(int n, long bufs) {
        long __functionAddress = GL.getCapabilities().glDrawBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, bufs);
    }

    public static void glDrawBuffers(IntBuffer bufs) {
        GL20.nglDrawBuffers(bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDrawBuffers(int buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer bufs = stack.ints(buf);
            GL20.nglDrawBuffers(1, MemoryUtil.memAddress(bufs));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        long __functionAddress = GL.getCapabilities().glBlendEquationSeparate;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, modeRGB, modeAlpha);
    }

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        long __functionAddress = GL.getCapabilities().glStencilOpSeparate;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, face, sfail, dpfail, dppass);
    }

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        long __functionAddress = GL.getCapabilities().glStencilFuncSeparate;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, face, func, ref, mask);
    }

    public static void glStencilMaskSeparate(int face, int mask) {
        long __functionAddress = GL.getCapabilities().glStencilMaskSeparate;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, face, mask);
    }

    public static void glShaderSource(int shader, PointerBuffer strings, int[] length) {
        long __functionAddress = GL.getCapabilities().glShaderSource;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, strings.remaining());
            }
        }
        JNI.callPPV(__functionAddress, shader, strings.remaining(), MemoryUtil.memAddress(strings), length);
    }

    public static void glUniform1fv(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2fv(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3fv(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4fv(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniform1iv(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2iv(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3iv(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4iv(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 9, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 4, transpose, value);
    }

    public static void glGetShaderiv(int shader, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, shader, pname, params);
    }

    public static void glGetProgramiv(int program, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, pname, params);
    }

    public static void glGetShaderInfoLog(int shader, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GL.getCapabilities().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, shader, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramInfoLog(int program, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GL.getCapabilities().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, program, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetAttachedShaders(int program, int[] count, int[] shaders) {
        long __functionAddress = GL.getCapabilities().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (count != null) {
                Checks.checkBuffer(count, 1);
            }
        }
        JNI.callPPV(__functionAddress, program, shaders.length, count, shaders);
    }

    public static void glGetActiveUniform(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetUniformfv(int program, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetShaderSource(int shader, int[] length, ByteBuffer source) {
        long __functionAddress = GL.getCapabilities().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, shader, source.remaining(), length, MemoryUtil.memAddress(source));
    }

    public static void glVertexAttrib1fv(int index, float[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 1);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1sv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 1);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1dv(int index, double[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib1dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 1);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, float[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 2);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2sv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 2);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2dv(int index, double[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 2);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, float[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 3);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3sv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 3);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3dv(int index, double[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 3);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, float[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4sv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4dv(int index, double[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4iv(int index, int[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4usv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4uiv(int index, int[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nsv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nsv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Niv(int index, int[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Niv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nusv(int index, short[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nuiv(int index, int[] v) {
        long __functionAddress = GL.getCapabilities().glVertexAttrib4Nuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glGetActiveAttrib(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetVertexAttribiv(int index, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribdv(int index, int pname, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetVertexAttribdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glDrawBuffers(int[] bufs) {
        long __functionAddress = GL.getCapabilities().glDrawBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, bufs.length, bufs);
    }
}

