/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRPartialUpdate {
    public static final int EGL_BUFFER_AGE_KHR = 12605;

    protected KHRPartialUpdate() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglSetDamageRegionKHR);
    }

    public static int neglSetDamageRegionKHR(long dpy, long surface, long rects, int n_rects) {
        long __functionAddress = EGL.getCapabilities().eglSetDamageRegionKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPPI(__functionAddress, dpy, surface, rects, n_rects);
    }

    public static boolean eglSetDamageRegionKHR(long dpy, long surface, IntBuffer rects) {
        return KHRPartialUpdate.neglSetDamageRegionKHR(dpy, surface, MemoryUtil.memAddressSafe(rects), rects == null ? 0 : rects.remaining()) != 0;
    }

    public static boolean eglSetDamageRegionKHR(long dpy, long surface, int[] rects) {
        long __functionAddress = EGL.getCapabilities().eglSetDamageRegionKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPPI(__functionAddress, dpy, surface, rects, rects == null ? 0 : rects.length) != 0;
    }
}

