package uk.ac.cam.cl.gfxintro.gd355.tick2;

import static org.lwjgl.opengl.GL20.*;

import java.nio.FloatBuffer;

import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.opengl.GL13.*;
import static org.lwjgl.opengl.GL13.glActiveTexture;


public class Water extends Mesh {


	Texture colTexture;
	Texture normTexture;
	Texture reflectionTexture;

	// Filenames for vertex and fragment shader source code
	private final static String VSHADER_FN = "resources/water_vertex_shader.glsl";
	private final static String FSHADER_FN = "resources/water_fragment_shader.glsl";

	public Water(Texture reflectionTexture) {
		super(new ShaderProgram(new Shader(GL_VERTEX_SHADER, VSHADER_FN), new Shader(GL_FRAGMENT_SHADER, FSHADER_FN), "colour"));

		this.reflectionTexture = reflectionTexture;

		colTexture = new Texture();
		colTexture.load("resources/water-0236.jpg");

		normTexture = new Texture();
		normTexture.load("resources/water 0236normal.jpg");
	}

	@Override
	float[] initializeVertexPositions() {
		float[] vertPositions = new float[] {
				-1, 0, -1,   +1, 0, -1, 
				+1, 0, +1,   -1, 0, +1
		};
		return vertPositions;
	}

	@Override
	int[] initializeVertexIndices() {
		int[] indices = new int[] {
				0, 2, 1, 
				0, 3, 2
		};
		return indices;
	}

	@Override
	float[] initializeVertexNormals() {
		float[] vertNormals = new float[] {
				0,  1,  0,  0,  1,  0,  
				0,  1,  0,  0,  1,  0  
		};
		return vertNormals;
	}

	@Override
	float[] initializeTextureCoordinates() {
		float[] texCoors = new float[] {
				0, 1,  1, 1,
				1, 0,  0, 0
		};
		return texCoors;
	}

	@Override
	void preRender(Camera c) {

		// enable alpha blending (transparency)
		glEnable(GL_BLEND); 
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		// texture
		glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D, colTexture.getTexId());
		int texture_location = glGetUniformLocation(shaders.getHandle(), "tex");
		glUniform1i(texture_location, 0);	

		// texture
		glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D, normTexture.getTexId());
		texture_location = glGetUniformLocation(shaders.getHandle(), "normTex");
		glUniform1i(texture_location, 1);	

		// texture
		glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, reflectionTexture.getTexId());
		texture_location = glGetUniformLocation(shaders.getHandle(), "reflectionTex");
		glUniform1i(texture_location, 2);	

		// time
		int time_location = glGetUniformLocation(shaders.getHandle(), "time");
		glUniform1f(time_location, runTimeInSeconds);
		
		// set reflected mvp matrix. this is necessary to map the reflection map onto the plane
		c.setReflected();
        Matrix4f refl_matrix; // Model-view-projection matrix
        refl_matrix = new Matrix4f(c.getProjectionMatrix()).mul(c.getViewMatrix()).mul(modelMatrix);
        int refl_location = glGetUniformLocation(shaders.getHandle(), "reflWorldViewProj");
        FloatBuffer refl_buffer = BufferUtils.createFloatBuffer(16);
        refl_matrix.get(refl_buffer);
        glUniformMatrix4fv(refl_location, false, refl_buffer);
        c.setNotReflected();
	}

	@Override
	void postRender(Camera c) {
		// we must disable blending, otherwise the next rendering could look funny 
		glDisable(GL_BLEND);
		
		// optionally could also unbind textures...
	}

}
