#version 330

in vec3 frag_normal;        // fragment normal in world space
in vec2 frag_texcoord;
in vec3 frag_worldPos; 
in vec4 frag_reflPos; 


out vec4 colour;


uniform sampler2D tex;  
uniform sampler2D normTex;  
uniform sampler2D reflectionTex; 

uniform float time;
uniform vec3 camera_location;

void main()
{

/* blue 
	colour = vec4(0.15, 0.54, 1, 1);
*/

/* blue opacity, lit
    const vec3 I_a = vec3(0.2, 0.2, 0.2);       // Ambient light intensity (and colour)
    vec3 C_diff = vec3(0.15, 0.54, 1);
   
    const float k_d = 0.8;                      // Diffuse light factor
    
	const vec3 I = vec3(0.941, 0.968, 1);   // Light intensity (and colour)
	vec3 L = normalize(vec3(2, 1.5, -0.5)); // The light direction as a unit vector
	vec3 N = vec3(0, 1, 0);                   // Normal in world coordinates
	vec3 V = normalize(camera_location - frag_worldPos); // view vector
	vec3 R = reflect(L, N);

	vec3 spec = vec3(1, 1, 1) * pow(max(0, dot(-R, V)), 20); 
	vec3 aColour = C_diff * I_a + C_diff * k_d * I * max(0, dot(N, L)) + spec * 0.8;
	colour = vec4(aColour, 1 - 0.2 * max(dot(V, N), 0));
*/

/* moving texture
    const vec3 I_a = vec3(0.2, 0.2, 0.2);       // Ambient light intensity (and colour)
	vec2 tc1 = frag_texcoord * 20 - time * vec2(0.006, 0.008);
	vec2 tc2 = frag_texcoord * 10 + time * vec2(0.01, 0.015);
	vec3 tex1 = texture(tex, tc1).xyz;
	vec3 tex2 = texture(tex, tc2).xyz;
    vec3 C_diff = vec3(0.15, 0.54, 1) * tex1 * tex2;
   
    const float k_d = 0.8;                      // Diffuse light factor
    
	const vec3 I = vec3(0.941, 0.968, 1);   // Light intensity (and colour)
	vec3 L = normalize(vec3(2, 1.5, -0.5)); // The light direction as a unit vector
	vec3 N = vec3(0, 1, 0);                   // Normal in world coordinates
	vec3 V = normalize(camera_location - frag_worldPos); // view vector
	vec3 R = reflect(L, N);

	vec3 spec = vec3(1, 1, 1) * pow(max(0, dot(-R, V)), 20); 
	vec3 aColour = C_diff * I_a + C_diff * k_d * I * max(0, dot(N, L)) + spec * 0.8;
	colour = vec4(aColour, 1 - 0.2 * max(dot(V, N), 0));
*/

/*bumped
   const vec3 I_a = vec3(0.2, 0.2, 0.2);       // Ambient light intensity (and colour)
	 
	vec2 tc1 = frag_texcoord * 20 - time * vec2(0.006, 0.008);
	vec2 tc2 = frag_texcoord * 10 + time * vec2(0.01, 0.015);

	vec3 tex1 = texture(tex, tc1).xyz;
	vec3 tex2 = texture(tex, tc2).xyz;
    vec3 C_diff = vec3(0.15, 0.54, 1) * tex1 * tex2;
    
    vec3 norm1 = texture(normTex, tc1).xyz * 2 - 1;
    vec3 norm2 = texture(normTex, tc2).xyz * 2 - 1;    
    vec3 norm = ((norm1 + norm2) / 2).xzy; // swizzle

    const float k_d = 0.8;                      // Diffuse light factor
    
	const vec3 I = vec3(0.941, 0.968, 1);   // Light intensity (and colour)
	vec3 L = normalize(vec3(2, 1.5, -0.5)); // The light direction as a unit vector
	vec3 N = normalize(norm);                   // Normal in world coordinates
	vec3 V = normalize(camera_location - frag_worldPos); // view vector
	vec3 R = reflect(L, N);

	vec3 spec = vec3(1, 1, 1) * pow(max(0, dot(-R, V)), 20); 
	vec3 aColour = C_diff * I_a + C_diff * k_d * I * max(0, dot(N, L)) + spec * 0.8;
	colour = vec4(aColour, 1 - 0.2 * max(dot(V, N), 0));
*/


   // reflective
    const vec3 I_a = vec3(0.2, 0.2, 0.2);       // Ambient light intensity (and colour)
	 
	vec2 tc1 = frag_texcoord * 20 - time * vec2(0.006, 0.008);
	vec2 tc2 = frag_texcoord * 10 + time * vec2(0.01, 0.015);

	vec3 tex1 = texture(tex, tc1).xyz;
	vec3 tex2 = texture(tex, tc2).xyz;
    vec3 C_diff = vec3(0.15, 0.54, 1) * tex1 * tex2;
    
    vec3 norm1 = texture(normTex, tc1).xyz * 2 - 1;
    vec3 norm2 = texture(normTex, tc2).xyz * 2 - 1;    
    vec3 norm = ((norm1 + norm2) / 2).xzy; // swizzle

    const float k_d = 0.8;                      // Diffuse light factor
    
	const vec3 I = vec3(0.941, 0.968, 1);   // Light intensity (and colour)
	vec3 L = normalize(vec3(2, 1.5, -0.5)); // The light direction as a unit vector
	vec3 N = normalize(norm);                   // Normal in world coordinates
	vec3 V = normalize(camera_location - frag_worldPos); // view vector
	vec3 R = reflect(L, N);

	vec3 spec = vec3(1, 1, 1) * pow(max(0, dot(-R, V)), 20); 
	vec3 aColour = C_diff * I_a + C_diff * k_d * I * max(0, dot(N, L)) + spec * 0.8;
	
	vec2 reflUV = vec2(frag_reflPos.x / frag_reflPos.w, frag_reflPos.y / frag_reflPos.w) / 2.f + 0.5f;
	vec3 reflColour = texture(reflectionTex, reflUV).xyz;
	
	colour = vec4(mix(reflColour, aColour, 0.6 + 0.4 * max(dot(V, N), 0)), 1 - 0.2 * max(dot(V, N), 0));
	
	
}

