/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;

class Options {
    static final boolean DEBUG = Options.hasOption(System.getProperty("joml.debug", "false"));
    static final boolean NO_UNSAFE = Options.hasOption(System.getProperty("joml.nounsafe", "false"));
    static final boolean FASTMATH = Options.hasOption(System.getProperty("joml.fastmath", "false"));
    static final boolean SIN_LOOKUP = Options.hasOption(System.getProperty("joml.sinLookup", "false"));
    static final int SIN_LOOKUP_BITS = Integer.parseInt(System.getProperty("joml.sinLookup.bits", "14"));
    static final boolean useNumberFormat = Options.hasOption(System.getProperty("joml.format", "true"));
    static final int numberFormatDecimals = Integer.parseInt(System.getProperty("joml.format.decimals", "3"));
    static final NumberFormat NUMBER_FORMAT = Options.decimalFormat();

    Options() {
    }

    static NumberFormat decimalFormat() {
        NumberFormat df;
        if (useNumberFormat) {
            char[] prec = new char[numberFormatDecimals];
            Arrays.fill(prec, '0');
            df = new DecimalFormat(" 0." + new String(prec) + "E0;-");
        } else {
            df = NumberFormat.getNumberInstance(Locale.ENGLISH);
            df.setGroupingUsed(false);
        }
        return df;
    }

    static boolean hasOption(String v) {
        if (v == null) {
            return false;
        }
        if (v.trim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(v);
    }
}

