/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;
import org.lwjgl.vulkan.VkRect2D;

public class VkRenderPassBeginInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int FRAMEBUFFER;
    public static final int RENDERAREA;
    public static final int CLEARVALUECOUNT;
    public static final int PCLEARVALUES;

    VkRenderPassBeginInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassBeginInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassBeginInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkRenderPassBeginInfo.nsType(this.address());
    }

    public long pNext() {
        return VkRenderPassBeginInfo.npNext(this.address());
    }

    public long renderPass() {
        return VkRenderPassBeginInfo.nrenderPass(this.address());
    }

    public long framebuffer() {
        return VkRenderPassBeginInfo.nframebuffer(this.address());
    }

    public VkRect2D renderArea() {
        return VkRenderPassBeginInfo.nrenderArea(this.address());
    }

    public int clearValueCount() {
        return VkRenderPassBeginInfo.nclearValueCount(this.address());
    }

    public VkClearValue.Buffer pClearValues() {
        return VkRenderPassBeginInfo.npClearValues(this.address());
    }

    public VkRenderPassBeginInfo sType(int value) {
        VkRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo pNext(long value) {
        VkRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderPass(long value) {
        VkRenderPassBeginInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo framebuffer(long value) {
        VkRenderPassBeginInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderArea(VkRect2D value) {
        VkRenderPassBeginInfo.nrenderArea(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo pClearValues(VkClearValue.Buffer value) {
        VkRenderPassBeginInfo.npClearValues(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo set(int sType, long pNext, long renderPass, long framebuffer, VkRect2D renderArea, VkClearValue.Buffer pClearValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.framebuffer(framebuffer);
        this.renderArea(renderArea);
        this.pClearValues(pClearValues);
        return this;
    }

    public VkRenderPassBeginInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkRenderPassBeginInfo set(VkRenderPassBeginInfo src) {
        return this.nset(src.address());
    }

    public static VkRenderPassBeginInfo malloc() {
        return VkRenderPassBeginInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkRenderPassBeginInfo calloc() {
        return VkRenderPassBeginInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkRenderPassBeginInfo create() {
        return new VkRenderPassBeginInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassBeginInfo create(long address) {
        return address == 0L ? null : new VkRenderPassBeginInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassBeginInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassBeginInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkRenderPassBeginInfo mallocStack() {
        return VkRenderPassBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassBeginInfo callocStack() {
        return VkRenderPassBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return VkRenderPassBeginInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassBeginInfo callocStack(MemoryStack stack) {
        return VkRenderPassBeginInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassBeginInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassBeginInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static long nframebuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FRAMEBUFFER);
    }

    public static VkRect2D nrenderArea(long struct) {
        return VkRect2D.create(struct + (long)RENDERAREA);
    }

    public static int nclearValueCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLEARVALUECOUNT);
    }

    public static VkClearValue.Buffer npClearValues(long struct) {
        return VkClearValue.create(MemoryUtil.memGetAddress(struct + (long)PCLEARVALUES), VkRenderPassBeginInfo.nclearValueCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nframebuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FRAMEBUFFER, value);
    }

    public static void nrenderArea(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERAREA, VkRect2D.SIZEOF);
    }

    public static void nclearValueCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLEARVALUECOUNT, value);
    }

    public static void npClearValues(long struct, VkClearValue.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCLEARVALUES, VkRenderPassBeginInfo.addressSafe(value));
        VkRenderPassBeginInfo.nclearValueCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassBeginInfo.nclearValueCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PCLEARVALUES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassBeginInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassBeginInfo.__struct(VkRenderPassBeginInfo.__member(4), VkRenderPassBeginInfo.__member(POINTER_SIZE), VkRenderPassBeginInfo.__member(8), VkRenderPassBeginInfo.__member(8), VkRenderPassBeginInfo.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkRenderPassBeginInfo.__member(4), VkRenderPassBeginInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        FRAMEBUFFER = layout.offsetof(3);
        RENDERAREA = layout.offsetof(4);
        CLEARVALUECOUNT = layout.offsetof(5);
        PCLEARVALUES = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<VkRenderPassBeginInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassBeginInfo newInstance(long address) {
            return new VkRenderPassBeginInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkRenderPassBeginInfo.nsType(this.address());
        }

        public long pNext() {
            return VkRenderPassBeginInfo.npNext(this.address());
        }

        public long renderPass() {
            return VkRenderPassBeginInfo.nrenderPass(this.address());
        }

        public long framebuffer() {
            return VkRenderPassBeginInfo.nframebuffer(this.address());
        }

        public VkRect2D renderArea() {
            return VkRenderPassBeginInfo.nrenderArea(this.address());
        }

        public int clearValueCount() {
            return VkRenderPassBeginInfo.nclearValueCount(this.address());
        }

        public VkClearValue.Buffer pClearValues() {
            return VkRenderPassBeginInfo.npClearValues(this.address());
        }

        public Buffer sType(int value) {
            VkRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer renderPass(long value) {
            VkRenderPassBeginInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(long value) {
            VkRenderPassBeginInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer renderArea(VkRect2D value) {
            VkRenderPassBeginInfo.nrenderArea(this.address(), value);
            return this;
        }

        public Buffer pClearValues(VkClearValue.Buffer value) {
            VkRenderPassBeginInfo.npClearValues(this.address(), value);
            return this;
        }
    }
}

