/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPushConstantRange;

public class VkPipelineLayoutCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SETLAYOUTCOUNT;
    public static final int PSETLAYOUTS;
    public static final int PUSHCONSTANTRANGECOUNT;
    public static final int PPUSHCONSTANTRANGES;

    VkPipelineLayoutCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineLayoutCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineLayoutCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineLayoutCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineLayoutCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineLayoutCreateInfo.nflags(this.address());
    }

    public int setLayoutCount() {
        return VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address());
    }

    public LongBuffer pSetLayouts() {
        return VkPipelineLayoutCreateInfo.npSetLayouts(this.address());
    }

    public int pushConstantRangeCount() {
        return VkPipelineLayoutCreateInfo.npushConstantRangeCount(this.address());
    }

    public VkPushConstantRange.Buffer pPushConstantRanges() {
        return VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address());
    }

    public VkPipelineLayoutCreateInfo sType(int value) {
        VkPipelineLayoutCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo pNext(long value) {
        VkPipelineLayoutCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo flags(int value) {
        VkPipelineLayoutCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo pSetLayouts(LongBuffer value) {
        VkPipelineLayoutCreateInfo.npSetLayouts(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo pPushConstantRanges(VkPushConstantRange.Buffer value) {
        VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo set(int sType, long pNext, int flags, LongBuffer pSetLayouts, VkPushConstantRange.Buffer pPushConstantRanges) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pSetLayouts(pSetLayouts);
        this.pPushConstantRanges(pPushConstantRanges);
        return this;
    }

    public VkPipelineLayoutCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkPipelineLayoutCreateInfo set(VkPipelineLayoutCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkPipelineLayoutCreateInfo malloc() {
        return VkPipelineLayoutCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineLayoutCreateInfo calloc() {
        return VkPipelineLayoutCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineLayoutCreateInfo create() {
        return new VkPipelineLayoutCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineLayoutCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineLayoutCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineLayoutCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineLayoutCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineLayoutCreateInfo mallocStack() {
        return VkPipelineLayoutCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineLayoutCreateInfo callocStack() {
        return VkPipelineLayoutCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineLayoutCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineLayoutCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineLayoutCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineLayoutCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nsetLayoutCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SETLAYOUTCOUNT);
    }

    public static LongBuffer npSetLayouts(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS), VkPipelineLayoutCreateInfo.nsetLayoutCount(struct));
    }

    public static int npushConstantRangeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PUSHCONSTANTRANGECOUNT);
    }

    public static VkPushConstantRange.Buffer npPushConstantRanges(long struct) {
        return VkPushConstantRange.create(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES), VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nsetLayoutCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SETLAYOUTCOUNT, value);
    }

    public static void npSetLayouts(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETLAYOUTS, MemoryUtil.memAddressSafe(value));
        VkPipelineLayoutCreateInfo.nsetLayoutCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npushConstantRangeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PUSHCONSTANTRANGECOUNT, value);
    }

    public static void npPushConstantRanges(long struct, VkPushConstantRange.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPUSHCONSTANTRANGES, VkPipelineLayoutCreateInfo.addressSafe(value));
        VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineLayoutCreateInfo.nsetLayoutCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS));
        }
        if (VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineLayoutCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineLayoutCreateInfo.__struct(VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SETLAYOUTCOUNT = layout.offsetof(3);
        PSETLAYOUTS = layout.offsetof(4);
        PUSHCONSTANTRANGECOUNT = layout.offsetof(5);
        PPUSHCONSTANTRANGES = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<VkPipelineLayoutCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineLayoutCreateInfo newInstance(long address) {
            return new VkPipelineLayoutCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineLayoutCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineLayoutCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineLayoutCreateInfo.nflags(this.address());
        }

        public int setLayoutCount() {
            return VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address());
        }

        public LongBuffer pSetLayouts() {
            return VkPipelineLayoutCreateInfo.npSetLayouts(this.address());
        }

        public int pushConstantRangeCount() {
            return VkPipelineLayoutCreateInfo.npushConstantRangeCount(this.address());
        }

        public VkPushConstantRange.Buffer pPushConstantRanges() {
            return VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineLayoutCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineLayoutCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineLayoutCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pSetLayouts(LongBuffer value) {
            VkPipelineLayoutCreateInfo.npSetLayouts(this.address(), value);
            return this;
        }

        public Buffer pPushConstantRanges(VkPushConstantRange.Buffer value) {
            VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address(), value);
            return this;
        }
    }
}

