/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtensionProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTENSIONNAME;
    public static final int SPECVERSION;

    VkExtensionProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExtensionProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExtensionProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer extensionName() {
        return VkExtensionProperties.nextensionName(this.address());
    }

    public String extensionNameString() {
        return VkExtensionProperties.nextensionNameString(this.address());
    }

    public int specVersion() {
        return VkExtensionProperties.nspecVersion(this.address());
    }

    public static VkExtensionProperties malloc() {
        return VkExtensionProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExtensionProperties calloc() {
        return VkExtensionProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExtensionProperties create() {
        return new VkExtensionProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExtensionProperties create(long address) {
        return address == 0L ? null : new VkExtensionProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExtensionProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExtensionProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExtensionProperties mallocStack() {
        return VkExtensionProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExtensionProperties callocStack() {
        return VkExtensionProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExtensionProperties mallocStack(MemoryStack stack) {
        return VkExtensionProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtensionProperties callocStack(MemoryStack stack) {
        return VkExtensionProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExtensionProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExtensionProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtensionProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtensionProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)EXTENSIONNAME, 256);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)EXTENSIONNAME);
    }

    public static int nspecVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPECVERSION);
    }

    static {
        Struct.Layout layout = VkExtensionProperties.__struct(VkExtensionProperties.__array(1, 256), VkExtensionProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTENSIONNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkExtensionProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExtensionProperties newInstance(long address) {
            return new VkExtensionProperties(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer extensionName() {
            return VkExtensionProperties.nextensionName(this.address());
        }

        public String extensionNameString() {
            return VkExtensionProperties.nextensionNameString(this.address());
        }

        public int specVersion() {
            return VkExtensionProperties.nspecVersion(this.address());
        }
    }
}

