/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkEventCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    VkEventCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkEventCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkEventCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkEventCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkEventCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkEventCreateInfo.nflags(this.address());
    }

    public VkEventCreateInfo sType(int value) {
        VkEventCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkEventCreateInfo pNext(long value) {
        VkEventCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkEventCreateInfo flags(int value) {
        VkEventCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkEventCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkEventCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkEventCreateInfo set(VkEventCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkEventCreateInfo malloc() {
        return VkEventCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkEventCreateInfo calloc() {
        return VkEventCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkEventCreateInfo create() {
        return new VkEventCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkEventCreateInfo create(long address) {
        return address == 0L ? null : new VkEventCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkEventCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkEventCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkEventCreateInfo mallocStack() {
        return VkEventCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkEventCreateInfo callocStack() {
        return VkEventCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkEventCreateInfo mallocStack(MemoryStack stack) {
        return VkEventCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkEventCreateInfo callocStack(MemoryStack stack) {
        return VkEventCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkEventCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkEventCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkEventCreateInfo.__struct(VkEventCreateInfo.__member(4), VkEventCreateInfo.__member(POINTER_SIZE), VkEventCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkEventCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkEventCreateInfo newInstance(long address) {
            return new VkEventCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkEventCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkEventCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkEventCreateInfo.nflags(this.address());
        }

        public Buffer sType(int value) {
            VkEventCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkEventCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkEventCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

