/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENT;
    public static final int LAYOUT;

    VkAttachmentReference(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkAttachmentReference(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAttachmentReference.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int attachment() {
        return VkAttachmentReference.nattachment(this.address());
    }

    public int layout() {
        return VkAttachmentReference.nlayout(this.address());
    }

    public VkAttachmentReference attachment(int value) {
        VkAttachmentReference.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference layout(int value) {
        VkAttachmentReference.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference set(int attachment, int layout) {
        this.attachment(attachment);
        this.layout(layout);
        return this;
    }

    public VkAttachmentReference nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkAttachmentReference set(VkAttachmentReference src) {
        return this.nset(src.address());
    }

    public static VkAttachmentReference malloc() {
        return VkAttachmentReference.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkAttachmentReference calloc() {
        return VkAttachmentReference.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkAttachmentReference create() {
        return new VkAttachmentReference(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAttachmentReference create(long address) {
        return address == 0L ? null : new VkAttachmentReference(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentReference.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentReference.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkAttachmentReference mallocStack() {
        return VkAttachmentReference.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference callocStack() {
        return VkAttachmentReference.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference mallocStack(MemoryStack stack) {
        return VkAttachmentReference.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentReference callocStack(MemoryStack stack) {
        return VkAttachmentReference.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattachment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYOUT);
    }

    public static void nattachment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYOUT, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference.__struct(VkAttachmentReference.__member(4), VkAttachmentReference.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENT = layout.offsetof(0);
        LAYOUT = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkAttachmentReference, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAttachmentReference newInstance(long address) {
            return new VkAttachmentReference(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int attachment() {
            return VkAttachmentReference.nattachment(this.address());
        }

        public int layout() {
            return VkAttachmentReference.nlayout(this.address());
        }

        public Buffer attachment(int value) {
            VkAttachmentReference.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(int value) {
            VkAttachmentReference.nlayout(this.address(), value);
            return this;
        }
    }
}

