/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRMatrix4f
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    OVRMatrix4f(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRMatrix4f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRMatrix4f.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer M() {
        return OVRMatrix4f.nM(this.address());
    }

    public float M(int index) {
        return OVRMatrix4f.nM(this.address(), index);
    }

    public OVRMatrix4f M(FloatBuffer value) {
        OVRMatrix4f.nM(this.address(), value);
        return this;
    }

    public OVRMatrix4f M(int index, float value) {
        OVRMatrix4f.nM(this.address(), index, value);
        return this;
    }

    public OVRMatrix4f nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRMatrix4f set(OVRMatrix4f src) {
        return this.nset(src.address());
    }

    public static OVRMatrix4f malloc() {
        return OVRMatrix4f.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRMatrix4f calloc() {
        return OVRMatrix4f.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRMatrix4f create() {
        return new OVRMatrix4f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRMatrix4f create(long address) {
        return address == 0L ? null : new OVRMatrix4f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRMatrix4f.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRMatrix4f.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRMatrix4f mallocStack() {
        return OVRMatrix4f.mallocStack(MemoryStack.stackGet());
    }

    public static OVRMatrix4f callocStack() {
        return OVRMatrix4f.callocStack(MemoryStack.stackGet());
    }

    public static OVRMatrix4f mallocStack(MemoryStack stack) {
        return OVRMatrix4f.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRMatrix4f callocStack(MemoryStack stack) {
        return OVRMatrix4f.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRMatrix4f.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRMatrix4f.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nM(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 16);
    }

    public static float nM(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + (long)(index * 4));
    }

    public static void nM(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nM(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = OVRMatrix4f.__struct(OVRMatrix4f.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static final class Buffer
    extends StructBuffer<OVRMatrix4f, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRMatrix4f newInstance(long address) {
            return new OVRMatrix4f(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer M() {
            return OVRMatrix4f.nM(this.address());
        }

        public float M(int index) {
            return OVRMatrix4f.nM(this.address(), index);
        }

        public Buffer M(FloatBuffer value) {
            OVRMatrix4f.nM(this.address(), value);
            return this;
        }

        public Buffer M(int index, float value) {
            OVRMatrix4f.nM(this.address(), index, value);
            return this;
        }
    }
}

