/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRErrorInfo;
import org.lwjgl.ovr.OVREyeRenderDesc;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRGraphicsLuid;
import org.lwjgl.ovr.OVRHmdDesc;
import org.lwjgl.ovr.OVRInitParams;
import org.lwjgl.ovr.OVRInputState;
import org.lwjgl.ovr.OVRSessionStatus;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRTextureSwapChainDesc;
import org.lwjgl.ovr.OVRTrackerDesc;
import org.lwjgl.ovr.OVRTrackerPose;
import org.lwjgl.ovr.OVRTrackingState;
import org.lwjgl.ovr.OVRViewScaleDesc;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OVR {
    public static final int ovrFalse = 0;
    public static final int ovrTrue = 1;
    public static final int ovrInit_Debug = 1;
    public static final int ovrInit_RequestVersion = 4;
    public static final int ovrInit_WritableBits = 0xFFFFFF;
    public static final int ovrLogLevel_Debug = 0;
    public static final int ovrLogLevel_Info = 1;
    public static final int ovrLogLevel_Error = 2;
    public static final int ovrHmd_None = 0;
    public static final int ovrHmd_DK1 = 3;
    public static final int ovrHmd_DKHD = 4;
    public static final int ovrHmd_DK2 = 6;
    public static final int ovrHmd_CB = 8;
    public static final int ovrHmd_Other = 9;
    public static final int ovrHmd_E3_2015 = 10;
    public static final int ovrHmd_ES06 = 11;
    public static final int ovrHmd_ES09 = 12;
    public static final int ovrHmd_ES11 = 13;
    public static final int ovrHmd_CV1 = 14;
    public static final int ovrHmdCap_DebugDevice = 16;
    public static final int ovrTrackingCap_Orientation = 16;
    public static final int ovrTrackingCap_MagYawCorrection = 32;
    public static final int ovrTrackingCap_Position = 64;
    public static final int ovrEye_Left = 0;
    public static final int ovrEye_Right = 1;
    public static final int ovrTrackingOrigin_EyeLevel = 0;
    public static final int ovrTrackingOrigin_FloorLevel = 1;
    public static final int ovrStatus_OrientationTracked = 1;
    public static final int ovrStatus_PositionTracked = 2;
    public static final int ovrTracker_Connected = 32;
    public static final int ovrTracker_PoseTracked = 4;
    public static final int ovrTexture_2D = 0;
    public static final int ovrTexture_2D_External = 1;
    public static final int ovrTexture_Cube = 2;
    public static final int ovrTextureBind_None = 0;
    public static final int ovrTextureBind_DX_RenderTarget = 1;
    public static final int ovrTextureBind_DX_UnorderedAccess = 2;
    public static final int ovrTextureBind_DX_DepthStencil = 4;
    public static final int OVR_FORMAT_UNKNOWN = 0;
    public static final int OVR_FORMAT_R8G8B8A8_UNORM = 4;
    public static final int OVR_FORMAT_R8G8B8A8_UNORM_SRGB = 5;
    public static final int OVR_FORMAT_B8G8R8A8_UNORM = 6;
    public static final int OVR_FORMAT_R16G16B16A16_FLOAT = 10;
    public static final int OVR_FORMAT_D16_UNORM = 11;
    public static final int OVR_FORMAT_D24_UNORM_S8_UINT = 12;
    public static final int OVR_FORMAT_D32_FLOAT = 13;
    public static final int OVR_FORMAT_D32_FLOAT_S8X24_UINT = 14;
    public static final int OVR_FORMAT_B5G6R5_UNORM = 1;
    public static final int OVR_FORMAT_B5G5R5A1_UNORM = 2;
    public static final int OVR_FORMAT_B4G4R4A4_UNORM = 3;
    public static final int OVR_FORMAT_B8G8R8A8_UNORM_SRGB = 7;
    public static final int OVR_FORMAT_B8G8R8X8_UNORM = 8;
    public static final int OVR_FORMAT_B8G8R8X8_UNORM_SRGB = 9;
    public static final int ovrTextureMisc_None = 0;
    public static final int ovrTextureMisc_DX_Typeless = 1;
    public static final int ovrTextureMisc_AllowGenerateMips = 2;
    public static final int ovrTextureMisc_ProtectedContent = 4;
    public static final int ovrButton_A = 1;
    public static final int ovrButton_B = 2;
    public static final int ovrButton_RThumb = 4;
    public static final int ovrButton_RShoulder = 8;
    public static final int ovrButton_RMask = 15;
    public static final int ovrButton_X = 256;
    public static final int ovrButton_Y = 512;
    public static final int ovrButton_LThumb = 1024;
    public static final int ovrButton_LShoulder = 2048;
    public static final int ovrButton_LMask = 3840;
    public static final int ovrButton_Up = 65536;
    public static final int ovrButton_Down = 131072;
    public static final int ovrButton_Left = 262144;
    public static final int ovrButton_Right = 524288;
    public static final int ovrButton_Enter = 0x100000;
    public static final int ovrButton_Back = 0x200000;
    public static final int ovrButton_VolUp = 0x400000;
    public static final int ovrButton_VolDown = 0x800000;
    public static final int ovrButton_Home = 0x1000000;
    public static final int ovrButton_Private = 0x1C00000;
    public static final int ovrTouch_A = 1;
    public static final int ovrTouch_B = 2;
    public static final int ovrTouch_RThumb = 4;
    public static final int ovrTouch_RIndexTrigger = 16;
    public static final int ovrTouch_RButtonMask = 23;
    public static final int ovrTouch_X = 256;
    public static final int ovrTouch_Y = 512;
    public static final int ovrTouch_LThumb = 1024;
    public static final int ovrTouch_LIndexTrigger = 4096;
    public static final int ovrTouch_LButtonMask = 5888;
    public static final int ovrTouch_RIndexPointing = 32;
    public static final int ovrTouch_RThumbUp = 64;
    public static final int ovrTouch_RPoseMask = 96;
    public static final int ovrTouch_LIndexPointing = 8192;
    public static final int ovrTouch_LThumbUp = 16384;
    public static final int ovrTouch_LPoseMask = 24576;
    public static final int ovrControllerType_None = 0;
    public static final int ovrControllerType_LTouch = 1;
    public static final int ovrControllerType_RTouch = 2;
    public static final int ovrControllerType_Touch = 3;
    public static final int ovrControllerType_Remote = 4;
    public static final int ovrControllerType_XBox = 16;
    public static final int ovrControllerType_Active = 255;
    public static final int ovrHand_Left = 0;
    public static final int ovrHand_Right = 1;
    public static final int ovrMaxLayerCount = 16;
    public static final int ovrLayerType_Disabled = 0;
    public static final int ovrLayerType_EyeFov = 1;
    public static final int ovrLayerType_Quad = 3;
    public static final int ovrLayerType_EyeMatrix = 5;
    public static final int ovrLayerFlag_HighQuality = 1;
    public static final int ovrLayerFlag_TextureOriginAtBottomLeft = 2;
    public static final int ovrLayerFlag_HeadLocked = 4;
    public static final int ovrPerfHud_Off = 0;
    public static final int ovrPerfHud_PerfSummary = 1;
    public static final int ovrPerfHud_LatencyTiming = 2;
    public static final int ovrPerfHud_AppRenderTiming = 3;
    public static final int ovrPerfHud_CompRenderTiming = 4;
    public static final int ovrPerfHud_VersionInfo = 5;
    public static final int ovrLayerHud_Off = 0;
    public static final int ovrLayerHud_Info = 1;
    public static final int ovrDebugHudStereo_Off = 0;
    public static final int ovrDebugHudStereo_Quad = 1;
    public static final int ovrDebugHudStereo_QuadWithCrosshair = 2;
    public static final int ovrDebugHudStereo_CrosshairAtInfinity = 3;

    protected OVR() {
        throw new UnsupportedOperationException();
    }

    public static native int novr_Initialize(long var0);

    public static int ovr_Initialize(OVRInitParams params) {
        return OVR.novr_Initialize(params == null ? 0L : params.address());
    }

    public static native void ovr_Shutdown();

    public static native void novr_GetLastErrorInfo(long var0);

    public static void ovr_GetLastErrorInfo(OVRErrorInfo errorInfo) {
        OVR.novr_GetLastErrorInfo(errorInfo.address());
    }

    public static native long novr_GetVersionString();

    public static String ovr_GetVersionString() {
        long __result = OVR.novr_GetVersionString();
        return MemoryUtil.memUTF8(__result);
    }

    public static native long novr_TraceMessage(int var0, long var1);

    public static String ovr_TraceMessage(int level, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkNT1(message);
        }
        long __result = OVR.novr_TraceMessage(level, MemoryUtil.memAddress(message));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ovr_TraceMessage(int level, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message);
            long __result = OVR.novr_TraceMessage(level, MemoryUtil.memAddress(messageEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void novr_GetHmdDesc(long var0, long var2);

    public static OVRHmdDesc ovr_GetHmdDesc(long session, OVRHmdDesc __result) {
        OVR.novr_GetHmdDesc(session, __result.address());
        return __result;
    }

    public static native int novr_GetTrackerCount(long var0);

    public static int ovr_GetTrackerCount(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetTrackerCount(session);
    }

    public static native void novr_GetTrackerDesc(long var0, int var2, long var3);

    public static OVRTrackerDesc ovr_GetTrackerDesc(long session, int trackerDescIndex, OVRTrackerDesc __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetTrackerDesc(session, trackerDescIndex, __result.address());
        return __result;
    }

    public static native int novr_Create(long var0, long var2);

    public static int ovr_Create(PointerBuffer pSession, OVRGraphicsLuid luid) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pSession, 1);
        }
        return OVR.novr_Create(MemoryUtil.memAddress(pSession), luid.address());
    }

    public static native void novr_Destroy(long var0);

    public static void ovr_Destroy(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_Destroy(session);
    }

    public static native int novr_GetSessionStatus(long var0, long var2);

    public static int ovr_GetSessionStatus(long session, OVRSessionStatus sessionStatus) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetSessionStatus(session, sessionStatus.address());
    }

    public static native int novr_SetTrackingOriginType(long var0, int var2);

    public static int ovr_SetTrackingOriginType(long session, int origin) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SetTrackingOriginType(session, origin);
    }

    public static native int novr_GetTrackingOriginType(long var0);

    public static int ovr_GetTrackingOriginType(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetTrackingOriginType(session);
    }

    public static native int novr_RecenterTrackingOrigin(long var0);

    public static int ovr_RecenterTrackingOrigin(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_RecenterTrackingOrigin(session);
    }

    public static native void novr_ClearShouldRecenterFlag(long var0);

    public static void ovr_ClearShouldRecenterFlag(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_ClearShouldRecenterFlag(session);
    }

    public static native void novr_GetTrackingState(long var0, double var2, boolean var4, long var5);

    public static OVRTrackingState ovr_GetTrackingState(long session, double absTime, boolean latencyMarker, OVRTrackingState __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetTrackingState(session, absTime, latencyMarker, __result.address());
        return __result;
    }

    public static native void novr_GetTrackerPose(long var0, int var2, long var3);

    public static OVRTrackerPose ovr_GetTrackerPose(long session, int trackerPoseIndex, OVRTrackerPose __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetTrackerPose(session, trackerPoseIndex, __result.address());
        return __result;
    }

    public static native int novr_GetInputState(long var0, int var2, long var3);

    public static int ovr_GetInputState(long session, int controllerType, OVRInputState inputState) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetInputState(session, controllerType, inputState.address());
    }

    public static native int novr_GetConnectedControllerTypes(long var0);

    public static int ovr_GetConnectedControllerTypes(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetConnectedControllerTypes(session);
    }

    public static native int novr_SetControllerVibration(long var0, int var2, float var3, float var4);

    public static int ovr_SetControllerVibration(long session, int controllerType, float frequency, float amplitude) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SetControllerVibration(session, controllerType, frequency, amplitude);
    }

    public static native int novr_GetTextureSwapChainLength(long var0, long var2, long var4);

    public static int ovr_GetTextureSwapChainLength(long session, long chain, IntBuffer out_Length) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
            Checks.checkBuffer((Buffer)out_Length, 1);
        }
        return OVR.novr_GetTextureSwapChainLength(session, chain, MemoryUtil.memAddress(out_Length));
    }

    public static native int novr_GetTextureSwapChainCurrentIndex(long var0, long var2, long var4);

    public static int ovr_GetTextureSwapChainCurrentIndex(long session, long chain, IntBuffer out_Index) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
            Checks.checkBuffer((Buffer)out_Index, 1);
        }
        return OVR.novr_GetTextureSwapChainCurrentIndex(session, chain, MemoryUtil.memAddress(out_Index));
    }

    public static native int novr_GetTextureSwapChainDesc(long var0, long var2, long var4);

    public static int ovr_GetTextureSwapChainDesc(long session, long chain, OVRTextureSwapChainDesc out_Desc) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
        }
        return OVR.novr_GetTextureSwapChainDesc(session, chain, out_Desc.address());
    }

    public static native int novr_CommitTextureSwapChain(long var0, long var2);

    public static int ovr_CommitTextureSwapChain(long session, long chain) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
        }
        return OVR.novr_CommitTextureSwapChain(session, chain);
    }

    public static native void novr_DestroyTextureSwapChain(long var0, long var2);

    public static void ovr_DestroyTextureSwapChain(long session, long chain) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_DestroyTextureSwapChain(session, chain);
    }

    public static native void novr_DestroyMirrorTexture(long var0, long var2);

    public static void ovr_DestroyMirrorTexture(long session, long mirrorTexture) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_DestroyMirrorTexture(session, mirrorTexture);
    }

    public static native void novr_GetFovTextureSize(long var0, int var2, long var3, float var5, long var6);

    public static OVRSizei ovr_GetFovTextureSize(long session, int eye, OVRFovPort fov, float pixelsPerDisplayPixel, OVRSizei __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetFovTextureSize(session, eye, fov.address(), pixelsPerDisplayPixel, __result.address());
        return __result;
    }

    public static native void novr_GetRenderDesc(long var0, int var2, long var3, long var5);

    public static OVREyeRenderDesc ovr_GetRenderDesc(long session, int eyeType, OVRFovPort fov, OVREyeRenderDesc __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetRenderDesc(session, eyeType, fov.address(), __result.address());
        return __result;
    }

    public static native int novr_SubmitFrame(long var0, long var2, long var4, long var6, int var8);

    public static int ovr_SubmitFrame(long session, long frameIndex, OVRViewScaleDesc viewScaleDesc, PointerBuffer layerPtrList) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SubmitFrame(session, frameIndex, viewScaleDesc == null ? 0L : viewScaleDesc.address(), MemoryUtil.memAddress(layerPtrList), layerPtrList.remaining());
    }

    public static native double novr_GetPredictedDisplayTime(long var0, long var2);

    public static double ovr_GetPredictedDisplayTime(long session, long frameIndex) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetPredictedDisplayTime(session, frameIndex);
    }

    public static native double ovr_GetTimeInSeconds();

    public static native boolean novr_GetBool(long var0, long var2, boolean var4);

    public static boolean ovr_GetBool(long session, ByteBuffer propertyName, boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetBool(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_GetBool(long session, CharSequence propertyName, boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_GetBool(session, MemoryUtil.memAddress(propertyNameEncoded), defaultVal);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetBool(long var0, long var2, boolean var4);

    public static boolean ovr_SetBool(long session, ByteBuffer propertyName, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetBool(session, MemoryUtil.memAddress(propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetBool(long session, CharSequence propertyName, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetBool(session, MemoryUtil.memAddress(propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetInt(long var0, long var2, int var4);

    public static int ovr_GetInt(long session, ByteBuffer propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetInt(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ovr_GetInt(long session, CharSequence propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetInt(session, MemoryUtil.memAddress(propertyNameEncoded), defaultVal);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetInt(long var0, long var2, int var4);

    public static boolean ovr_SetInt(long session, ByteBuffer propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetInt(session, MemoryUtil.memAddress(propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetInt(long session, CharSequence propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetInt(session, MemoryUtil.memAddress(propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float novr_GetFloat(long var0, long var2, float var4);

    public static float ovr_GetFloat(long session, ByteBuffer propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetFloat(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float ovr_GetFloat(long session, CharSequence propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            float f = OVR.novr_GetFloat(session, MemoryUtil.memAddress(propertyNameEncoded), defaultVal);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloat(long var0, long var2, float var4);

    public static boolean ovr_SetFloat(long session, ByteBuffer propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetFloat(session, MemoryUtil.memAddress(propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetFloat(long session, CharSequence propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloat(session, MemoryUtil.memAddress(propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetFloatArray(long var0, long var2, long var4, int var6);

    public static int ovr_GetFloatArray(long session, ByteBuffer propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), values.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ovr_GetFloatArray(long session, CharSequence propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyNameEncoded), MemoryUtil.memAddress(values), values.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloatArray(long var0, long var2, long var4, int var6);

    public static boolean ovr_SetFloatArray(long session, ByteBuffer propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), values.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetFloatArray(long session, CharSequence propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyNameEncoded), MemoryUtil.memAddress(values), values.remaining());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long novr_GetString(long var0, long var2, long var4);

    public static String ovr_GetString(long session, ByteBuffer propertyName, ByteBuffer defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
            if (defaultVal != null) {
                Checks.checkNT1(defaultVal);
            }
        }
        long __result = OVR.novr_GetString(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddressSafe(defaultVal));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ovr_GetString(long session, CharSequence propertyName, CharSequence defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            ByteBuffer defaultValEncoded = stack.UTF8(defaultVal);
            long __result = OVR.novr_GetString(session, MemoryUtil.memAddress(propertyNameEncoded), MemoryUtil.memAddressSafe(defaultValEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetString(long var0, long var2, long var4);

    public static boolean ovr_SetString(long hmddesc, ByteBuffer propertyName, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(hmddesc);
            Checks.checkNT1(propertyName);
            Checks.checkNT1(value);
        }
        return OVR.novr_SetString(hmddesc, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetString(long hmddesc, CharSequence propertyName, CharSequence value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(hmddesc);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            ByteBuffer valueEncoded = stack.ASCII(value);
            boolean bl = OVR.novr_SetString(hmddesc, MemoryUtil.memAddress(propertyNameEncoded), MemoryUtil.memAddress(valueEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetTextureSwapChainLength(long var0, long var2, int[] var4);

    public static int ovr_GetTextureSwapChainLength(long session, long chain, int[] out_Length) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
            Checks.checkBuffer(out_Length, 1);
        }
        return OVR.novr_GetTextureSwapChainLength(session, chain, out_Length);
    }

    public static native int novr_GetTextureSwapChainCurrentIndex(long var0, long var2, int[] var4);

    public static int ovr_GetTextureSwapChainCurrentIndex(long session, long chain, int[] out_Index) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkPointer(chain);
            Checks.checkBuffer(out_Index, 1);
        }
        return OVR.novr_GetTextureSwapChainCurrentIndex(session, chain, out_Index);
    }

    public static native int novr_GetFloatArray(long var0, long var2, float[] var4, int var5);

    public static int ovr_GetFloatArray(long session, ByteBuffer propertyName, float[] values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyName), values, values.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ovr_GetFloatArray(long session, CharSequence propertyName, float[] values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyNameEncoded), values, values.length);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloatArray(long var0, long var2, float[] var4, int var5);

    public static boolean ovr_SetFloatArray(long session, ByteBuffer propertyName, float[] values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyName), values, values.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ovr_SetFloatArray(long session, CharSequence propertyName, float[] values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyNameEncoded), values, values.length);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.initialize();
    }
}

