/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class OESDrawElementsBaseVertex {
    protected OESDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glDrawElementsBaseVertexOES, ext.contains("GLES30") ? caps.glDrawRangeElementsBaseVertexOES : -1L, ext.contains("GLES30") ? caps.glDrawElementsInstancedBaseVertexOES : -1L, ext.contains("EXT_multi_draw_arrays") ? caps.glMultiDrawElementsBaseVertexOES : -1L);
    }

    public static void nglDrawElementsBaseVertexOES(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertexOES(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawRangeElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertexOES(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, IntBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertexOES(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertexOES(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        OESDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexOES(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertexOES(int mode, int[] count, int type, PointerBuffer indices, int[] basevertex) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indices, count.length);
            Checks.checkBuffer(basevertex, count.length);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length, basevertex);
    }
}

