/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawInstanced {
    protected EXTDrawInstanced() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstancedEXT, caps.glDrawElementsInstancedEXT);
    }

    public static void glDrawArraysInstancedEXT(int mode, int start, int count, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawArraysInstancedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, start, count, primcount);
    }

    public static void nglDrawElementsInstancedEXT(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int count, int type, long indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

