/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;

    protected INTELMapTexture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glSyncTextureINTEL, caps.glUnmapTexture2DINTEL, caps.glMapTexture2DINTEL);
    }

    public static void glSyncTextureINTEL(int texture) {
        long __functionAddress = GL.getCapabilities().glSyncTextureINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture);
    }

    public static void glUnmapTexture2DINTEL(int texture, int level) {
        long __functionAddress = GL.getCapabilities().glUnmapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, level);
    }

    public static long nglMapTexture2DINTEL(int texture, int level, int access, long stride, long layout) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 1);
            Checks.checkBuffer((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return MemoryUtil.memByteBuffer(__result, INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 1);
            Checks.checkBuffer((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, long length, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 1);
            Checks.checkBuffer((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(stride, 1);
            Checks.checkBuffer(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        return MemoryUtil.memByteBuffer(__result, INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, ByteBuffer old_buffer) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(stride, 1);
            Checks.checkBuffer(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, int[] stride, int[] layout, long length, ByteBuffer old_buffer) {
        long __functionAddress = GL.getCapabilities().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(stride, 1);
            Checks.checkBuffer(layout, 1);
        }
        long __result = JNI.callPPP(__functionAddress, texture, level, access, stride, layout);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    private static int getStride(IntBuffer stride) {
        return stride.get(stride.position());
    }

    private static int getStride(int[] stride) {
        return stride[0];
    }
}

