/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBDebugOutput {
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 33346;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_ARB = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 33347;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_ARB = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_ARB = 33349;
    public static final int GL_DEBUG_SOURCE_API_ARB = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_ARB = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_ARB = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_ARB = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_ARB = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_ARB = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_ARB = 33361;
    public static final int GL_DEBUG_SEVERITY_HIGH_ARB = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_ARB = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_ARB = 37192;

    protected ARBDebugOutput() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDebugMessageControlARB, caps.glDebugMessageInsertARB, caps.glDebugMessageCallbackARB, caps.glGetDebugMessageLogARB);
    }

    public static void nglDebugMessageControlARB(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControlARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControlARB(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, 1, MemoryUtil.memAddress(ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageInsertARB(int source, int type, int id, int severity, int length, long buf) {
        long __functionAddress = GL.getCapabilities().glDebugMessageInsertARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, id, severity, length, buf);
    }

    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, ByteBuffer buf) {
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, CharSequence buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer bufEncoded = stack.UTF8(buf, false);
            int bufEncodedLen = bufEncoded.capacity();
            ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, bufEncodedLen, MemoryUtil.memAddress(bufEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageCallbackARB(long callback, long userParam) {
        long __functionAddress = GL.getCapabilities().glDebugMessageCallbackARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, callback, userParam);
    }

    public static void glDebugMessageCallbackARB(GLDebugMessageARBCallbackI callback, long userParam) {
        ARBDebugOutput.nglDebugMessageCallbackARB(callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLogARB(int count, int bufSize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPPPPPI(__functionAddress, count, bufSize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLogARB(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return ARBDebugOutput.nglGetDebugMessageLogARB(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControlARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, ids == null ? 0 : ids.length, ids, enabled);
    }

    public static int glGetDebugMessageLogARB(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (sources != null) {
                Checks.checkBuffer(sources, count);
            }
            if (types != null) {
                Checks.checkBuffer(types, count);
            }
            if (ids != null) {
                Checks.checkBuffer(ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer(severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer(lengths, count);
            }
        }
        return JNI.callPPPPPPI(__functionAddress, count, messageLog == null ? 0 : messageLog.remaining(), sources, types, ids, severities, lengths, MemoryUtil.memAddressSafe(messageLog));
    }
}

