/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AMDDebugOutput {
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_AMD = 37189;
    public static final int GL_DEBUG_SEVERITY_HIGH_AMD = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_AMD = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_AMD = 37192;
    public static final int GL_DEBUG_CATEGORY_API_ERROR_AMD = 37193;
    public static final int GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 37194;
    public static final int GL_DEBUG_CATEGORY_DEPRECATION_AMD = 37195;
    public static final int GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 37196;
    public static final int GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 37197;
    public static final int GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 37198;
    public static final int GL_DEBUG_CATEGORY_APPLICATION_AMD = 37199;
    public static final int GL_DEBUG_CATEGORY_OTHER_AMD = 37200;

    protected AMDDebugOutput() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDebugMessageEnableAMD, caps.glDebugMessageInsertAMD, caps.glDebugMessageCallbackAMD, caps.glGetDebugMessageLogAMD);
    }

    public static void nglDebugMessageEnableAMD(int category, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageEnableAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, category, severity, count, ids, enabled);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, IntBuffer ids, boolean enabled) {
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageEnableAMD(int category, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, 1, MemoryUtil.memAddress(ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageInsertAMD(int category, int severity, int id, int length, long buf) {
        long __functionAddress = GL.getCapabilities().glDebugMessageInsertAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, category, severity, id, length, buf);
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, ByteBuffer buf) {
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertAMD(int category, int severity, int id, CharSequence buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer bufEncoded = stack.UTF8(buf, false);
            int bufEncodedLen = bufEncoded.capacity();
            AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, bufEncodedLen, MemoryUtil.memAddress(bufEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageCallbackAMD(long callback, long userParam) {
        long __functionAddress = GL.getCapabilities().glDebugMessageCallbackAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, callback, userParam);
    }

    public static void glDebugMessageCallbackAMD(GLDebugMessageAMDCallbackI callback, long userParam) {
        AMDDebugOutput.nglDebugMessageCallbackAMD(callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLogAMD(int count, int bufsize, long categories, long severities, long ids, long lengths, long messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPPPPI(__functionAddress, count, bufsize, categories, severities, ids, lengths, messageLog);
    }

    public static int glGetDebugMessageLogAMD(int count, IntBuffer categories, IntBuffer severities, IntBuffer ids, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void glDebugMessageEnableAMD(int category, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageEnableAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, category, severity, ids == null ? 0 : ids.length, ids, enabled);
    }

    public static int glGetDebugMessageLogAMD(int count, int[] categories, int[] severities, int[] ids, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLogAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (categories != null) {
                Checks.checkBuffer(categories, count);
            }
            if (severities != null) {
                Checks.checkBuffer(severities, count);
            }
            if (ids != null) {
                Checks.checkBuffer(ids, count);
            }
            if (lengths != null) {
                Checks.checkBuffer(lengths, count);
            }
        }
        return JNI.callPPPPPI(__functionAddress, count, messageLog == null ? 0 : messageLog.remaining(), categories, severities, ids, lengths, MemoryUtil.memAddressSafe(messageLog));
    }
}

