/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class SOFTSourceLatency {
    public static final int AL_SAMPLE_OFFSET_LATENCY_SOFT = 4608;
    public static final int AL_SEC_OFFSET_LATENCY_SOFT = 4609;

    protected SOFTSourceLatency() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCapabilities caps) {
        return Checks.checkFunctions(caps.alSourcedSOFT, caps.alSource3dSOFT, caps.alSourcedvSOFT, caps.alGetSourcedSOFT, caps.alGetSource3dSOFT, caps.alGetSourcedvSOFT, caps.alSourcei64SOFT, caps.alSource3i64SOFT, caps.alSourcei64vSOFT, caps.alGetSourcei64SOFT, caps.alGetSource3i64SOFT, caps.alGetSourcei64vSOFT);
    }

    public static void alSourcedSOFT(int source, int param, double value) {
        long __functionAddress = AL.getCapabilities().alSourcedSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokeV(__functionAddress, source, param, value);
    }

    public static void alSource3dSOFT(int source, int param, double value1, double value2, double value3) {
        long __functionAddress = AL.getCapabilities().alSource3dSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokeV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void nalSourcedvSOFT(int source, int param, long value) {
        long __functionAddress = AL.getCapabilities().alSourcedvSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alSourcedvSOFT(int source, int param, DoubleBuffer value) {
        SOFTSourceLatency.nalSourcedvSOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void nalGetSourcedSOFT(int source, int param, long value) {
        long __functionAddress = AL.getCapabilities().alGetSourcedSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alGetSourcedSOFT(int source, int param, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        SOFTSourceLatency.nalGetSourcedSOFT(source, param, MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double alGetSourcedSOFT(int source, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer value = stack.callocDouble(1);
            SOFTSourceLatency.nalGetSourcedSOFT(source, param, MemoryUtil.memAddress(value));
            double d = value.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nalGetSource3dSOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = AL.getCapabilities().alGetSource3dSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSource3dSOFT(int source, int param, DoubleBuffer value1, DoubleBuffer value2, DoubleBuffer value3) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value1, 1);
            Checks.checkBuffer((Buffer)value2, 1);
            Checks.checkBuffer((Buffer)value3, 1);
        }
        SOFTSourceLatency.nalGetSource3dSOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void nalGetSourcedvSOFT(int source, int param, long values) {
        long __functionAddress = AL.getCapabilities().alGetSourcedvSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }

    public static void alGetSourcedvSOFT(int source, int param, DoubleBuffer values) {
        SOFTSourceLatency.nalGetSourcedvSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alSourcei64SOFT(int source, int param, long value) {
        long __functionAddress = AL.getCapabilities().alSourcei64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokeJV(__functionAddress, source, param, value);
    }

    public static void alSource3i64SOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = AL.getCapabilities().alSource3i64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokeJJJV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void nalSourcei64vSOFT(int source, int param, long values) {
        long __functionAddress = AL.getCapabilities().alSourcei64vSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }

    public static void alSourcei64vSOFT(int source, int param, LongBuffer values) {
        SOFTSourceLatency.nalSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetSourcei64SOFT(int source, int param, long value) {
        long __functionAddress = AL.getCapabilities().alGetSourcei64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alGetSourcei64SOFT(int source, int param, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        SOFTSourceLatency.nalGetSourcei64SOFT(source, param, MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alGetSourcei64SOFT(int source, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer value = stack.callocLong(1);
            SOFTSourceLatency.nalGetSourcei64SOFT(source, param, MemoryUtil.memAddress(value));
            long l = value.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nalGetSource3i64SOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = AL.getCapabilities().alGetSource3i64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSource3i64SOFT(int source, int param, LongBuffer value1, LongBuffer value2, LongBuffer value3) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value1, 1);
            Checks.checkBuffer((Buffer)value2, 1);
            Checks.checkBuffer((Buffer)value3, 1);
        }
        SOFTSourceLatency.nalGetSource3i64SOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void nalGetSourcei64vSOFT(int source, int param, long values) {
        long __functionAddress = AL.getCapabilities().alGetSourcei64vSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }

    public static void alGetSourcei64vSOFT(int source, int param, LongBuffer values) {
        SOFTSourceLatency.nalGetSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alSourcedvSOFT(int source, int param, double[] value) {
        long __functionAddress = AL.getCapabilities().alSourcedvSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alGetSourcedSOFT(int source, int param, double[] value) {
        long __functionAddress = AL.getCapabilities().alGetSourcedSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alGetSource3dSOFT(int source, int param, double[] value1, double[] value2, double[] value3) {
        long __functionAddress = AL.getCapabilities().alGetSource3dSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value1, 1);
            Checks.checkBuffer(value2, 1);
            Checks.checkBuffer(value3, 1);
        }
        JNI.invokePPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSourcedvSOFT(int source, int param, double[] values) {
        long __functionAddress = AL.getCapabilities().alGetSourcedvSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }

    public static void alSourcei64vSOFT(int source, int param, long[] values) {
        long __functionAddress = AL.getCapabilities().alSourcei64vSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }

    public static void alGetSourcei64SOFT(int source, int param, long[] value) {
        long __functionAddress = AL.getCapabilities().alGetSourcei64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value, 1);
        }
        JNI.invokePV(__functionAddress, source, param, value);
    }

    public static void alGetSource3i64SOFT(int source, int param, long[] value1, long[] value2, long[] value3) {
        long __functionAddress = AL.getCapabilities().alGetSource3i64SOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(value1, 1);
            Checks.checkBuffer(value2, 1);
            Checks.checkBuffer(value3, 1);
        }
        JNI.invokePPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSourcei64vSOFT(int source, int param, long[] values) {
        long __functionAddress = AL.getCapabilities().alGetSourcei64vSOFT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, source, param, values);
    }
}

