/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector3fc;

public class Planef {
    public float a;
    public float b;
    public float c;
    public float d;

    public Planef() {
    }

    public Planef(Planef source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
    }

    public Planef(Vector3fc point, Vector3fc normal) {
        this.a = normal.x();
        this.b = normal.y();
        this.c = normal.z();
        this.d = -this.a * point.x() - this.b * point.y() - this.c * point.z();
    }

    public Planef(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Planef set(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        return this;
    }

    public Planef normalize() {
        float invLength = (float)(1.0 / Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c));
        this.a *= invLength;
        this.b *= invLength;
        this.c *= invLength;
        this.d *= invLength;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.a);
        result = 31 * result + Float.floatToIntBits(this.b);
        result = 31 * result + Float.floatToIntBits(this.c);
        result = 31 * result + Float.floatToIntBits(this.d);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Planef other = (Planef)obj;
        if (Float.floatToIntBits(this.a) != Float.floatToIntBits(other.a)) {
            return false;
        }
        if (Float.floatToIntBits(this.b) != Float.floatToIntBits(other.b)) {
            return false;
        }
        if (Float.floatToIntBits(this.c) != Float.floatToIntBits(other.c)) {
            return false;
        }
        return Float.floatToIntBits(this.d) == Float.floatToIntBits(other.d);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "[" + formatter.format(this.a) + " " + formatter.format(this.b) + " " + formatter.format(this.c) + " " + formatter.format(this.d) + "]";
    }
}

