// Supervision1.cpp 
//

#include <opencv2/opencv.hpp>
#ifdef _DEBUG
#pragma comment(lib, "opencv_world340d.lib")
#else
#pragma comment(lib, "opencv_world340.lib")
#endif


#include <iostream>
#include <chrono>


// Entry point for the supervision exercises for week 1
int main()
{
	//----------------------------------------------------------------------------------------------------------
	// Initial loading. Feel free to read, but please do not change
	//
	cv::Mat loadedImage = cv::imread("images/king_fisher_2.png", cv::IMREAD_GRAYSCALE);
	if (loadedImage.empty())
	{
		throw std::runtime_error("Failed to load Source image");
		return 1;
	}

	// convert to floats
	cv::Mat srcImage;
	loadedImage.convertTo(srcImage, CV_32F, 1/255.f);

	// display Source image
	cv::namedWindow("Source Image", cv::WINDOW_AUTOSIZE); 
	cv::imshow("Source Image", srcImage);


	//----------------------------------------------------------------------------------------------------------
	// Kernel construction
	//
	// feel free to try out the different kernels, or to add your own
	//
	// IMPORTANT: these kernels are not unified. They may not sum to 1. 
	// Remember to always divide by kernelSize*kernelSize after/while convolving
	//
	int kernelSize = 3;
	cv::Mat kernel1 = cv::Mat::ones(kernelSize, kernelSize, CV_32F);
	cv::Mat kernel2 = cv::getGaussianKernel(kernelSize, kernelSize * 0.6, CV_32F) * kernelSize * kernelSize;
	cv::Mat kernel3 = cv::Mat(kernelSize, kernelSize, CV_32F);
	for (int i = 0; i < kernel3.rows; i++)
	{
		kernel3.row(i).setTo((-1 + i * 2.f / (kernelSize - 1)) * kernelSize * kernelSize);
	}

	// active kernel
	cv::Mat kernel = kernel3;

	//----------------------------------------------------------------------------------------------------------
	// Exercise 1.
	// Convolution using for loops. Write a loop based implementation of the convolution of 
	// srcImage and kernel outputting the result to image1
	// Feel free to use slide 59 (pseudo code)
	//
	// The following line of code might help you to get the color of a pixel at (x,y)
	// float value = srcImage.at<float>(cv::Point(x,y)
	// 
	// ... and to set a pixel at (x,y) to value
	// image1.at<float>(cv::Point(x, y)) = value;
	//
	// note that pixel values are floats ranging from 0 to 1
	//
	//
	auto beginTime = std::chrono::system_clock::now();
	cv::Mat image1 = cv::Mat::zeros(srcImage.size(), srcImage.type());
	

	// TODO: convolve srcImage and image1 using 4 for loops 


	auto endTime = std::chrono::system_clock::now();
	std::chrono::duration<double> elapsedTime = endTime - beginTime;
	std::cout << "delta time for Exercise 1: " << elapsedTime.count() << "s" << std::endl;
	cv::namedWindow("Expercise 1", cv::WINDOW_AUTOSIZE);
	cv::imshow("Expercise 1", image1);

	
	
	//----------------------------------------------------------------------------------------------------------
	// Exercise 2.
	// Using the convolution theorem from slide 57, apply the kernel in the Fourier domain
	// convolve srcImage and kernel to image2
	//
	beginTime = std::chrono::system_clock::now();
	cv::Mat image2 = cv::Mat::zeros(srcImage.size(), srcImage.type());

	
	// padding. we need to make sure that the two matrices have equal size
	cv::Mat kernelPadded;


	// TODO: use cv::copyMakeBorder(kernel, kernelPadded, ...) to add a constant (black) border.
	// TODO: you can fiddle with the numbers to ensure that the adding is symmetric, or just add the padding to the right and bottom


	// Fourier transform
	cv::Mat srcFourier, kernelFourier;
	

	// TODO compute the Fourier transforms using cv::dft(src, target) 
	// TODO: do this for both srcImage->srcFourier and kernelPadded->kernelFourier


	// multiply in the Fourier domain
	cv::Mat image2Fourier;


	// TODO: use opencv's cv::mulSpectrums to multiply the two arrays.


	// inverse Fourier
	

	// TODO: uncomment this line once image2Fourier is correctly computed
	// cv::idft(image2Fourier, image2, cv::DFT_SCALE);


	// TODO: divide image2 by the kernel size (remember, the Kernel wasn't normalised)


	endTime = std::chrono::system_clock::now();
	elapsedTime = endTime - beginTime;
	std::cout << "delta time for Exercise 2: " << elapsedTime.count() << "s" << std::endl;
	cv::namedWindow("Expercise 2", cv::WINDOW_AUTOSIZE);
	cv::imshow("Expercise 2", image2);


	//----------------------------------------------------------------------------------------------------------
	// Exercise 3.
	//
	// Using OpenCV's built-in filtering function
	//
	beginTime = std::chrono::system_clock::now();
	cv::Mat image3 = cv::Mat::zeros(srcImage.size(), srcImage.type());
	

	// TODO: apply cv::filter2D from srcImage to image3 with the kernel


	// TODO: divide image3 by the kernel size (remember, the Kernel wasn't normalised)


	endTime = std::chrono::system_clock::now();
	elapsedTime = endTime - beginTime;
	std::cout << "delta time for Exercise 3: " << elapsedTime.count() << "s" << std::endl;
	cv::namedWindow("Expercise 3", cv::WINDOW_AUTOSIZE);
	cv::imshow("Expercise 3", image3);

	///////// FINISHED
	cv::waitKey(0); // Wait for a keystroke in the window
	return 0;
}
