\name{xyeplot}
\title{Scatterplot with error bars}
\alias{panel.superpose2}
\alias{xyeplot}
\description{
  A scatter plot of one variable against another. The vertical axis is
  drawn with error bars.
}
\synopsis{
xyeplot(x,data,...,err,jitter.x=TRUE,panel=panel.xyeplot,prepanel=prepanel.xyeplot,subgroups,subscripts=TRUE,accumulator)
}
\usage{
xyeplot(x,data,...,err)
xyeplot(x,data,...,err,jitter.x,subgroups,type='b',accumulator=panel.superpose2)
}
\arguments{
  \item{x}{a formula to plot, of the form \code{y~x|cond}, as in \code{\link[lattice]{xyplot}}}
  \item{data}{a data frame containing any variables in the formula}
  \item{err}{a numeric vector; bars will be drawn from \code{y+err} to
    \code{y-err}. \code{err} is also allowed to be a list with two
    elements, the positive error bars and the negative error bars.}
  \item{subgroups}{a subgrouping of the data, finer than the
    \code{groups} argument; points with the same value of \code{groups}
    are plotted in the same colour, and points with the same value of
    \code{subgroups} are connected by a line (if specified by
    \code{type})}
  \item{accumulator}{a function specifying how the data is to be broken
    down into groups and subgroups; the default is
    \code{panel.superpose} unless \code{subgroups} is specified in which
    case the default is \code{panel.superpose2}}
  \item{type}{as in \code{\link[lattice]{xyplot}}, the \code{type}
    argument specifies whether the plot shows lines, points, etc.}
  \item{jitter.x}{whether to jitter x-coordinates, when there are
    several groups and the x-coordinate is a factor; \code{jitter.x} may be
    either a boolean saying whether to jitter, or a number saying how
    much to jitter}
  \item{...}{other arguments for \code{\link[lattice]{xyplot}}}
}
\value{
  an object of class "trellis", as returned by \code{\link[lattice]{xyplot}}.
}
\author{DJW}
\examples{
data(ChickWeight)
df <- aggregateList(weight, by=list(Chick=Chick,Diet=Diet),data=ChickWeight,
                FUN=list(mean=mean,se=function(x) sd(x)/sqrt(length(x))))
xyeplot(mean~Chick, groups=Diet, err=se, data=df)
}
\keyword{hplot}
