\name{xcumsum}
\alias{xcumsum}
\title{Cumulative sum, by groups}
\description{
  Split the data into subsets, and compute cumulative sums within
  each subset, then reassemble back into the original order. This is
  useful when for example you want to compute running totals within
  groups.
}
\usage{
xcumsum(formula, orderby=1, data=parent.frame(), subset, na=0)
}
\arguments{
  \item{formula}{a formula of the form \code{x~var1+...+varn},
    where \code{x} is numeric and \code{var1,...,varn} are
    cross-classifying variables.}
  \item{orderby}{an optional vector specifying the order; this is
    typically of the form \code{order(var0)}.}
  \item{data}{an optional matrix or data frame containing the variables
    in \code{formula}}
  \item{subset}{an optional vector specifying a subset of the
    observations to be used}
  \item{na}{all the \code{NA} values in \code{x} are replaced by this}
  }
\value{
  A numeric vector of the same length as \code{x} (or shorter, if the
  subset was specified), containing cumulative sums within groups,
  ordered according to \code{orderby}.
}
\author{DJW}
\examples{

df <- data.frame(x=c(1,2,3,2,2,1,3,2),
                 a=c('red','red','blue','blue','blue','red','blue','blue'),
                 b=c(9,10,11,12,3,4,7,6))
df$tot <- xcumsum(x~a, order(b), data=df) 
}