\name{whichbegin}
\alias{\%whichbegin\%}
\alias{\%whichcontain\%}
\alias{\%begins\%}
\alias{\%contains\%}
\title{Select character strings by prefix or substring}
\description{
  Selects those elements from a character vector with a given prefix or substring.}
\usage{
str \%whichbegin\% prefixes
str \%whichcontain\% substrings
str \%begins\% prefixes
str \%contains\% substrings
}
\arguments{
  \item{str}{a character vector to be selected from}
  \item{prefixes}{the prefixes to match}
  \item{substrings}{the substrings to match}
}
\value{
  \code{\%whichbegin\%} returns those elements of \code{str} which begin
  with one of the prefixes in \code{prefixes}. \code{\%begins\%} returns
  a boolean vector indicating which elements of \code{str} begin with
  one of those prefixes.

  \code{\%whichcontain\%} and \code{\%contains\%} work the same, but
  with substrings instead of prefixes.

  The matching is done with regular expressions. The \code{\%begin\%}
  commands simply prefix the regular expression with a \code{^}.
}
\author{DJW}
\examples{
c('winsome','wet','windy') \%whichbegin\% 'win'
c('winsome','wet','windy') \%begins\% 'win'
c('winsome','wet','windy') \%whichcontain\% c('s','t')
}
\keyword{character}

