\name{tablemargin}
\title{Add totals to tables}
\alias{addmargins.table}
\alias{propmargins.table}
\description{
  Add a column of totals to one or more indexes of a table,
  and show percentages of those totals.
}
\usage{
addmargins.table(x, margin=seq(along=dim(x)), FUN=sum)
propmargins.table(x, margin=seq(along=dim(x)), margin.prop=margin)
}
\arguments{
  \item{x}{a table, e.g. the result of calling \code{xtabs}}
  \item{margin}{a numeric vector, indicating the indexes over which
    totals should be calculated. E.g. \code{1}=rows, \code{2}=columns,
    \code{c(1,2)}=both rows and columns}
  \item{margin.prop}{a numeric vector, indicating the indexes over which
    percentages should be calculated. E.g. \code{1}=rows sum to 100\%,
    \code{2}=columns sum to 100\%, \code{c(1,2)}=rows and columns
    together sum to 100\%}
  \item{FUN}{the function to be applied, for calculating margins}
}
\value{
  \code{addmargins.table} returns a
  table, with an extra level called \code{TOTAL} added to each of the
  indexes for which the summary was requested.

  \code{propmargins.table} returns a nicely formatted version, and also
  shows percentages of the \code{TOTAL}.
  }
\author{DJW}
\seealso{\code{\link{xtabs}}, \code{\link{prop.table}}}
\examples{
data(ChickWeight)
tab <- xtabs(~cut(Time,breaks=5)+Diet, data=ChickWeight)
addmargins.table(tab, margin=2)
print(propmargins.table(tab, margin=c(1,2)), quote=FALSE)
print(propmargins.table(tab, margin=c(1,2), margin.prop=1), quote=FALSE)
print(propmargins.table(tab, margin=c(1,2), margin.prop=2), quote=FALSE)
}
\keyword{manip}
