\name{RweaveLatex.djw}
\alias{RweaveLatex.djw}
\title{An alternative driver for Sweave, which facilitates labelling}
\description{
  This driver for \code{Sweave} facilitates labelling.
  It causes the label of a chunk of code to be passed as an option
  to the Latex environment.
}
\usage{
RweaveLatex.djw()
}
\details{
  Typical usage is
  \preformatted{Sweave('mycode.Rnw', driver=RweaveLatex.djw())}
  Then, code inside \code{mycode.Rnw} such as
  \preformatted{<<mylabel,echo=TRUE>>
    x <- rnorm(10)
    x
    @
  }
  will generate Latex in which the output chunk begins
  \preformatted{\begin{Soutput}[label=mylabel]
  }
  This can be used to make Latex print labels on each output chunk,
  for example in conjunction with the definition
  \preformatted{\DefineVerbatimEnvironment{Soutput}{Verbatim}{frame=single}
  }
  (The \code{label=mylabel} is passed as an extra option to the
  \code{Soutput} environment. The \code{frame=single} option is needed,
  because without a frame the label will not be printed. See
  Latex help on
  \code{fancyvrb} for more details on \code{Verbatim} environments.)
  
  Note that if a single chunk of code produces several output chunks,
  then each output chunk will use the same label.
}
\author{DJW}
\keyword{misc}
