\name{strstrip}
\alias{strstrip}
\title{Remove whitespace at the beginning and end of a string}
\description{Remove whitespace from the beginning and end of a string.}
\usage{
strstrip(x, space='[:space:]', inside=FALSE)
}
\arguments{
  \item{x}{a character vector, containing the strings to be stripped of
    whitespace}
  \item{space}{a string, indicating what is considered to be whitespace}
  \item{inside}{a boolean. If \code{TRUE}, then sequences of whitespace
    within the string are collapsed into a single space character.}
}
\value{
  a character vector, containing the stripped strings
}
\keyword{character}
\author{DJW}
\examples{
# strip whitespace at the beginning and end
strstrip(c('what ','  seems  ',' to\tbe\t\r','\rthe  matter?'))

# also strip whitespace in the middle
strstrip(c('what ','  seems  ',' to\tbe\t\r','\rthe  matter?'),inside=TRUE)

# keep only alphabetical characters, not punctuation
strstrip(c('15what ','  seems  ',' to\tbe\t\r','\rthe  matter?'),space='^[:alpha:]',inside=TRUE)
}
