\name{simpleKey2}
\title{Function to generate a simple key for a plot}
\alias{simpleKey2}
\alias{levelsUsed}
\description{
  Simple interface for adding a key to a lattice plot. This is a more
  flexible replacement for \code{simpleKey} from \code{lattice}.
}
\usage{
simpleKey2(text,outof=seq(along=text),points=TRUE,rectangles=FALSE,lines=FALSE,
columns,rows,byrow,
col,cex,font,fontface,fontfamily,
...)
levelsUsed(x)
}
\arguments{
  \item{text}{character vector, to be used as labels for levels of the
    grouping variable}
  \item{outof}{numeric or character vector, which links the levels in \code{text}
    to the Lattice graphics-style settings}
  \item{points,rectangles,lines}{whether to show these components as
    part of the key; each \code{TRUE} or \code{FALSE}}
  \item{columns,rows}{the number of rows and columns to use for
    the key; each is an integer but only one should be specified}
  \item{byrow}{whether to lay out the items of the key by row or by
    column; either \code{TRUE} or \code{FALSE}}
  \item{col,cex,font,fontface,fontfamily,...}{further graphical
    parameters, eventually added to the list and returned to
    \code{draw.key}}
  \item{x}{a factor}
  }
\details{
  A lattice plot can include a legend (key). This is useful when the
  \code{groups} argument has been specified to
  \code{\link[lattice]{xyplot}}. The \code{simpleKey2} function is a
  shortcut for generating simple keys. It displays the entries in
  \code{text}, and chooses the colours according to the default Lattice
  settings. To change the colours, use
  \code{\link[lattice]{trellis.par.set}}.

  If \code{outof} is left blank, then \code{text} should refer to the
  levels of \code{groups} in their proper order (i.e. the
  order in which Lattice assignes colours).

  If \code{outof} is
  a numeric vector, it specifies the indexes within \code{groups} that
  the label refers to. For example, \code{text=c('b','a'),outof=c(2,1)}
  says that the first label \code{'b'} is actually the second level of
  group. This is useful for reordering the key and giving fancy names to
  the groups.
  
  If \code{outof} is a character vector, then it should refer to the
  full set of levels of \code{groups} in their proper order, and
  \code{text} specifies which of those levels should actually be
  included in the key. For example,
  \code{text=c('a','c'),outof=c('a','b','c')} says to only include
  levels \code{'a'} and \code{'c'} in the key, and that these two labels
  refer to the first and third levels of \code{groups}. This is useful
  for omitting unused levels from the key, in conjunction with
  \code{levelsUsed}, as in the example below.

  The \code{levelsUsed} function returns those levels of the factor
  \code{x} which are actually present in \code{x}.}
\value{
  A list that would work as the \code{key} argument to \code{xyplot} etc.
}
\seealso{
  \code{\link[lattice]{simpleKey}}, \code{\link[lattice]{draw.key}},
  \code{\link[lattice]{xyplot}}
  }
\author{DJW}
\examples{
# Change the default Lattice settings
trellis.par.set(col.whitebg())
gsl <- trellis.par.get('superpose.symbol')
gsl$pch <- 1:3
trellis.par.set('superpose.symbol',gsl)

data(iris)
xyplot(Sepal.Length~Petal.Length, groups=Species, data=iris,
       key=simpleKey2(levels(iris$Species),rows=1))

iris.v <- iris[iris$Species!='setosa',]
xyplot(Sepal.Length~Petal.Length, groups=Species, data=iris.v,
       key=simpleKey2(text=levelsUsed(iris.v$Species), outof=levels(iris.v$Species),columns=1,space='right'))
}
\keyword{aplot}
