\name{repsafe}
\alias{repsafe}
\title{A safe version of rep}
\description{
  Like \code{\link{rep}}, but it issues warnings when unexpected lengths
  are called for.
}
\usage{
repsafe(x, length.out)
}
\arguments{
  \item{x}{a vector to be repeated}
  \item{length.out}{the desired length}
}
\details{
  Throws a warning if \code{x} is both longer than 1 and of a different
  length to \code{length.out}. (This is an easy way to make errors.)
}
\value{
  a vector with \code{x} repeated to give total length \code{length.out}.
}
\author{DJW}
\seealso{\code{\link{rep}}}
\examples{
# safe
repsafe(3,length.out=10)
# unsafe
repsafe(c(2,3), length.out=10)
}
\keyword{manip}
