\name{prettytable}
\alias{prettytable}
\alias{print.prettytable}
\title{Pretty formatting of data frames}
\description{Print data frames, in a constrained space, wrapping long
  entries if necessary}
\usage{
prettytable(df,wrap=integer(0))
\method{print}{prettytable}(x,\dots, digits=NULL, na.encode=FALSE, rowsep=NA,
colsep=' ', justify='left', rowsperpage=Inf)
}
\arguments{
  \item{df}{a data frame to be prettified}
  \item{wrap}{an named integer vector; each entry controls how the named
    column will be wrapped. If the wrapping for a column is unspecified,
    then it takes its natural width. If the wrapping is specified to be
    \code{w}, then the column can shrink to a minimum width \code{w}, or
    it can grow to its natural width, subject to the page width set by
    \code{options('width')}}
  \item{x}{a prettytable object}
  \item{\dots}{extra arguments, ignored}
  \item{digits,na.encode}{the data frame is first formatted using these
    arguments; see \code{\link{format.data.frame}}}
  \item{rowsep}{a character string to be printed underneath the column
    headings, e.g. "-"; it is repeated as necessary to match the full width of the
    table}
  \item{colsep}{a character string to be printed between columns, e.g. "|"}
  \item{justify}{how text columns are to be justified; passed on to
    \code{\link{format}}}
  \item{rowsperpage}{the number of rows of the data frame to print,
    before repeating the column headings}
  }
  \value{
    \code{prettytable} converts its argument \code{df} into a data
    frame, if necessary, and it returns the data frame as a
    ``prettytable'' object
  }
  \examples{
df <- prettytable(data.frame(x=1:10*7.3,y=NA),wrap=c('y'=10))
df[3,'y'] <- "This is a very long string of text with lots and lots of words"
options(width=20)
df
print(df,rowsep='-',colsep='|',justify='right')
}
\author{DJW}



