\name{predictFactors}
\alias{predictFactors}
\alias{predictFactors.lm}
\alias{predictFactors.lme}
\alias{predictFactors.glm}
\alias{predictFactorsWork}
\title{Extracting factor coefficients from fitted models}
\description{
  \code{predictFactors} extracts the estimate and standard error of
  various combinations of factor levels from a fitted model. But whereas
  \code{predict} insists that all terms in the model must be specified
  in the new data frame, \code{predictFactors} permits some to be left
  unspecified.}
\usage{
predictFactors(fit,new,...)
\method{predictFactors}{lm}(fit,new,contrasts,...)
\method{predictFactors}{lme}(fit,new,contrasts,...)
\method{predictFactors}{glm}(fit,new,contrasts,...)
}
\arguments{
  \item{fit}{a fitted model, fit with e.g. \code{lm} or \code{lme} or \code{glm}}
  \item{new}{a data frame with columns for each of the model variables
    which are factors in \code{fit}}
  \item{contrasts}{an optional named list of length 1,
    e.g. \code{list(Dose='0')}, specifying that
    the reported estimates and standard errors are to be relative to the
    specified base level}
  \item{...}{other arguments; discarded}
}
\value{
    a matrix with three columns called \code{estimate}, \code{std.error}
    and \code{Pr(>.)}, of class \code{\link{Coefmat}}.

    Each estimate produced by \code{predictFactors} corresponds to a row in the data frame
    \code{new}. This data frame should contain a column for each factor
    appearing in the model \code{fit}, and the entries should be levels
    of that factor (or \code{"MEAN"} or \code{NA}). The estimate produced for row \code{i}
    is simply the sum of
    the model coefficients for the factor levels specified in row
\code{i}. (It is obtained by
    relevelling each factor to have the specified base level, then
    extracting the \code{(Intercept)} term from the summary.)

    If the requested level of a factor is \code{"MEAN"}, then the estimate
    corresponds to sum contrasts over that factor, i.e. the function reports the
    average coefficient across all levels of that factor. If the
    requested level of a factor is \code{NA}, then the estimate uses
    the same contrasts as were used in the fit.

    If \code{contrasts} is specified,
    e.g. \code{contrasts=list(Dose='0')}, then the reported estimate
    labelled by e.g. the level \code{Dose10} is the contrast between the
    base level \code{0} and the desired level \code{10}.
}
\details{
  The first method is generic. Currently it is only implemented for the
  three types of fit listed here.
  }
\author{DJW}
\seealso{See \code{\link[stats]{predict}} for the standard prediction
  method}
\examples{
data(warpbreaks)
fit <- lm(breaks~wool*tension, data=warpbreaks)

# extract the population averages in the sample
df <- crossproduct(wool=levels(warpbreaks$wool),
                   tension=c(levels(warpbreaks$tension),'MEAN'))
predictFactors(fit, new=df)

# extract contrasts between wool='A' and the other level of A
df <- crossproduct(wool=levels(warpbreaks$wool)[-1],
                   tension=c(levels(warpbreaks$tension),'MEAN'))
predictFactors(fit, new=df, contrasts=list(wool='A'))
}
\keyword{models}
