\name{fold}
\alias{fold}
\title{Binary operations on lists of vectors}
\description{
  Binary operations like \code{+} and \code{*} work on two
  arguments. This function lets you fold a binary operation over a list:
  \code{pointwise(list(x,y,z),FUN=f)} calculates
  \code{f(f(x,y),z)}.
}
\usage{
fold(x, FUN, ...)
}
\arguments{
  \item{x}{a list of vectors}
  \item{FUN}{a function taking at least two arguments}
  \item{...}{any additional arguments for FUN}
}
\value{
  \code{FUN(---FUN(FUN(x[[1]],x[[2]]),x[[3]])---)}
}
\author{DJW}
\examples{
fold( list(2,3,4), FUN=function(x,y) x+y )
}
\keyword{arith}
