\name{keepna}
\alias{keepna}
\title{Turn NA values into a factor level}
\description{
  Use \code{keepna} when tabulating, if you want to explicitly see NA values
}
\usage{
keepna(x)
}
\arguments{
  \item{x}{A vector, of any class}
}
\value{
  If \code{x} has no NA entries, the value is \code{x}.
  If \code{x} has one or more NA entries, \code{x} is turned into a
  factor, and the NA values converted into the factor level 'NA'.
}
\author{DJW}
\examples{
df <- data.frame(x=c('a','a','b','b','b'),y=c(1,2,2,2,NA))
xtabs(~x+y, data=df)
xtabs(~x+keepna(y), data=df)
}
\keyword{manip}
