\name{jitterDJW}
\alias{jitterDJW}
\title{Add jitter to grouped numbers}
\description{Adds a small amount of non-random jitter to a numeric vector.
  It is done in a way that is suitable for plotting grouped
  data: it shifts all numbers in a given group by the same amount, and it
  scales the jitter in proportion to the within-group distances.}
\usage{
jitterDJW(x,groups,subscripts,jitter.x=1/20)
}
\arguments{
  \item{x}{a numeric vector to be jittered}
  \item{jitter.x}{the amount by which to jitter}
  \item{groups}{a factor, of the same length as \code{x}, which governs
    the jittering scale factor}
  \item{subscripts}{a numeric vector, specifying the subset of \code{x}
    and \code{groups} which will be used to calculate how much to
    jitter}
}
\value{
  Consider plotting grouped data, \code{xyplot(y~x, groups=g)}.
  We may not want the x-values from different groups to overlap,
  especially if we are also plotting error bars (as with
  \code{\link{bwplot2}} or \code{\link{xyeplot}}). To prevent this,
  \code{jitterDJW} jitters the x values, jittering all the points in a
  given group by the same amount. 

  It chooses jitter in proportion to the distances between x values
  within each group. For example, if the groups all have x values
  of 3, 3.8 and 6 it will choose a jitter of \code{jitter.x}*0.8. 
  
  The return value is a numeric vector of the same length as \code{x}.
}
\author{DJW}
\seealso{\code{\link{jitter}};
it is also used internally in \code{\link{xyeplot}} and \code{\link{bwplot2}}}
\examples{
jitterDJW(c(1,2,2,3), groups=c('a','a','b','b'))
}
