\name{coxphPenal}
\alias{summary.coxph.penal}
\alias{print.summary.coxph.penal}
\title{Summarize a coxph frailty model}
\description{Summarizes a coxph frailty model, and allows access to the
  computed summary statistics}
\usage{
\method{summary}{coxph.penal}(object,conf.int=0.95,scale=1,terms=FALSE,maxlabel=25,\dots)
}
\arguments{
  \item{object,conf.int,scale,terms,maxlabel,\dots}{exactly as for
    \code{\link{summary.coxph.penal}}}
}
\details{
  The \code{summary} command for fraily coxph models prints its
  output, which is no use if you want to extract values
  programmatically.
  This replacement function returns an R object, so you can inspect and
  manipulate all its parts.
}
\seealso{
  \code{\link{summary.coxph.penal}}
  \code{\link[survival]{frailty}}
}
\keyword{survival}
\examples{
data(kidney)
kfit <- coxph(Surv(time,status) ~ age+sex+disease + frailty(id), data=kidney)

# Display the entire summary
summary(kfit)

# Show just a little of the summary
x <- summary(kfit)
x$table[c('age','sex'),c('coef','p')]
  }

  