\name{comp-approx}
\alias{equal.num}
\alias{leq.num}
\alias{geq.num}
\alias{comp.num}
\alias{equal.numall}
\title{Approximate numerical comparison}
\description{
  Comparisons between two numerical vectors, allowing for
  machine-precision inaccuracies.
}
\usage{
equal.num(x,y)
leq.num(x,y)
geq.num(x,y)
comp.num(x,y)
}
\arguments{
  \item{x,y}{numerical vectors}
}
\value{
  \item{equal.num}{returns a vector of TRUE/FALSE indicating whether the
    elements of \code{x} and \code{y} are (nearly) equal, in the
    sense of \code{\link{all.equal}}}
  \item{leq.num}{is x<=y (nearly)?}
  \item{geq.num}{is x>=y (nearly)?}
  \item{comp.num}{0 if x==y, 1 if x>y, -1 if x<y (nearly)}
}
\author{DJW}
\keyword{arith}
