\name{alphanumeric-sort}
\alias{splitAlphaNum}
\alias{orderAlphaNum}
\alias{sortAlphaNum}
\title{Split a character vector into alternating character and numerical
  parts, and sort it}
\description{
  Split a character vector into alternating character and numerical
  parts. This is useful for indexing strings intuitively, so that for
  example \code{abc.9} comes before \code{abc.10}. Under normal
  lexicographic ordering of characters, \code{abc.10} comes before
  \code{abc.9}.
}
\usage{
splitAlphaNum(str, first=c('character','numeric'))
orderAlphaNum(str,...)
sortAlphaNum(str,...)

}
\arguments{
  \item{str}{a character vector}
  \item{first}{a specification of whether the function should look first
    for a character portion or a numeric portion}
  \item{...}{arguments to be passed to \code{splitAlphaNum}}
}
\value{
  \code{sortAlphaNum} sorts its argument, after splitting
  it into alphabetic and numerical parts. For example,
  \code{sortAlphaNum(c('abc.10','abc.9'))} returns
  \code{c('abc.9','abc.10')}.

  \code{orderAlphaNum} returns a permutation which sorts its argument
  into ascending order.
  
  \code{splitAlphaNum} returns a list of alternating character and
  numeric vectors (whether the first vector is character or numeric
  depends on the \code{first} argument). This list is as long as the
  maximum number of alternating elements in any string in \code{str}.
  The elements of the list are named either \code{character} or
  \code{numeric}.

  For example, \code{splitAlphaNum(c('abc.10','abc.9'))} returns a list
  with two components, the first \code{c('abc.','abc.')}, the second
  \code{c(10,9)}.
}
\author{DJW}
\examples{
x <- c('v5','v7.50b','v7.55b','v8','v13')
sort(x)
sortAlphaNum(x)

# Should numbers or characters come first in the ordering?
x <- c('10','a5')
sortAlphaNum(x,first='character')  # characters come first
sortAlphaNum(x,first='numeric')    # numbers come first
}
\keyword{character}
